#' Sample Data
#'
#' This sample data is a dataset used in: Nicolosi Gelis, María Mercedes; Cochero, Joaquín; Donadelli, Jorge; Gómez, Nora. 2020. "Exploring the use of nuclear alterations, motility and ecological guilds in epipelic diatoms as biomonitoring tools for water quality improvement in urban impacted lowland streams". Ecological Indicators, 110, 105951.
#'
#' @format A data frame with the abundance of 164 diatoms in 108 sampled sites
#' @docType data
#' @usage data(diat_sampleData)
#' @encoding UTF-8
#' @source \url{https://doi.org/10.1016/j.ecolind.2019.105951}
#' @references Nicolosi Gelis, María Mercedes; Cochero, Joaquín; Donadelli, Jorge; Gómez, Nora. 2020. "Exploring the use of nuclear alterations, motility and ecological guilds in epipelic diatoms as biomonitoring tools for water quality improvement in urban impacted lowland streams". Ecological Indicators, 110, 105951.
"diat_sampleData"

#' Acronyms
#'
#' Contains the acronyms for diatom species
#'
#' @format A data frame with the acronyms of 16823 diatoms
#' @docType data
#' @usage data(acronyms)
#' @encoding UTF-8
"acronyms"

#' DBC (offline)
#'
#' Diatom database from the 'Diat.Barcode' project V9.0
#'
#' @format A data frame with ecological and morphological information for 8066 diatoms
#' @docType data
#' @usage data(dbc_offline)
#' @encoding UTF-8
#' @source \url{https://doi.org/10.1051/kmae/2012018}
#' @references Rimet F. & Bouchez A., 2012. Life-forms, cell-sizes and ecological guilds of diatoms in European rivers. Knowledge and management of aquatic ecosystems, 406: 1-14. DOI:10.1051/kmae/2012018
"dbc_offline"

#' DES
#'
#' Index values for diatom species included in the DES index
#'
#' @format A data frame with the ecological values for 622 species
#' @docType data
#' @usage data(des)
#' @encoding UTF-8
#' @source \url{http://pascal-francis.inist.fr/vibad/index.php?action=getRecordDetail&idt=PASCAL8060205402}
#' @references Descy, J. P. 1979. A new approach to water qualityestimation  using  diatom.  Beih.  Nov  Hedw. 64:305-323
"des"

#' EPID
#'
#' Index values for diatom species included in the EPID index
#'
#' @format A data frame with the ecological values for 1038 species
#' @docType data
#' @usage data(epid)
#' @encoding UTF-8
#' @source \url{https://www.tib.eu/en/search/id/BLCP:CN034949165/Use-of-algae-for-monitoring-rivers-in-the-Czech?cHash=fdd9e0b1bf812a31ec0f692a273cab04}
#' @references Dell'Uomo, A. (1996). Assessment of water quality of an Apennine river as a pilot study for diatom-based monitoring of Italian watercourses. Use of algae for monitoring rivers, 65-72.
"epid"

#' IDAP
#'
#' Index values for diatom species included in the IDAP index
#'
#' @format A data frame with the ecological values for 194 species
#' @docType data
#' @usage data(idap)
#' @encoding UTF-8
#' @source \url{https://doi.org/10.1007/BF00028033}
#' @references Prygiel, J., & Coste, M. (1993). The assessment of water quality in the Artois-Picardie water basin (France) by the use of diatom indices. Hydrobiologia, 269(1), 343-349.
"idap"

#' ID-CH
#'
#' Index values for diatom species included in the IC-CH index
#'
#' @format A data frame with the ecological values for 550 species
#' @docType data
#' @usage data(idch)
#' @encoding UTF-8
#' @source \url{https://www.bafu.admin.ch/bafu/fr/home/themes/eaux/publications/publications-eaux/methodes-analyse-appreciation-cours-eau-diatomees.html}
#' @references Hürlimann J., Niederhauser P. (2007). Méthodes d’analyse et d’appréciation des cours d’eau. Diatomées Niveau R (région). État de l’environnement n° 0740. Office fédéral de l’environnement, Berne. 132 p
"idch"

#' IDP
#'
#' Index values for diatom species included in the IDP index
#'
#' @format A data frame with the ecological values for 475 species
#' @docType data
#' @usage data(idp)
#' @encoding UTF-8
#' @source \url{https://doi.org/10.1023/A:1011415209445}
#' @references Gómez, N., & Licursi, M. (2001). The Pampean Diatom Index (IDP) for assessment of rivers and streams in Argentina. Aquatic Ecology, 35(2), 173-181.
"idp"

#' ILM
#'
#' Index values for diatom species included in the ILM index
#'
#' @format A data frame with the ecological values for 667 species
#' @docType data
#' @usage data(ilm)
#' @encoding UTF-8
#' @source \url{http://www.vliz.be/imisdocs/publications/286641.pdf}
#' @references Leclercq, L., & Maquet, B. (1987). Deux nouveaux indices diatomique et de qualité chimique des eaux courantes. Comparaison avec différents indices existants. Cahier de Biology Marine, 28, 303-310
"ilm"

#' IPS
#'
#' Index values for diatom species included in the IPS index
#'
#' @format A data frame with the ecological values for 6881 species
#' @docType data
#' @usage data(ips)
#' @encoding UTF-8
#' @source \url{https://www.oieau.org/eaudoc/notice/ETUDE-DES-METHODES-BIOLOGIQUES-DAPPRECIATION-QUANTITATIVE-DE-LA-QUALITE-DES-EAUX}
#' @references Coste, M. (1982). Étude des méthodes biologiques d’appréciation quantitative de la qualité des eaux. Rapport Cemagref QE Lyon-AF Bassin Rhône Méditerranée Corse.
"ips"

#' LOBO
#'
#' Index values for diatom species included in the LOBO index
#'
#' @format A data frame with the ecological values for 297 species
#' @docType data
#' @usage data(lobo)
#' @encoding UTF-8
#' @references Lobo, E. A., Callegaro, V. L. M., & Bender, E. P. (2002). Utilização de algas diatomáceas epilíticas como indicadoras da qualidade da água em rios e arroios da Região Hidrográfica do Guaíba, RS, Brasil. Edunisc.
"lobo"

#' SLA
#'
#' Index values for diatom species included in the SLA index
#'
#' @format A data frame with the ecological values for 976 species
#' @docType data
#' @usage data(sla)
#' @encoding UTF-8
#' @source \url{https://doi.org/10.1002/aheh.19860140519}
#' @references Sládeček, V. (1986). Diatoms as indicators of organic pollution. Acta hydrochimica et hydrobiologica, 14(5), 555-566.
"sla"

#' SPEAR(h)
#'
#' Index values for diatom species included in the SPEAR(h) index
#'
#' @format A data frame with the ecological values for 285 species
#' @docType data
#' @usage data(spear)
#' @encoding UTF-8
#' @source \url{https://doi.org/10.1016/j.ecolind.2018.12.035}
#' @references Wood, R. J., Mitrovic, S. M., Lim, R. P., Warne, M. S. J., Dunlop, J., & Kefford, B. J. (2019). Benthic diatoms as indicators of herbicide toxicity in rivers–A new SPEcies At Risk (SPEARherbicides) index. Ecological Indicators, 99, 203-213.
"spear"

#' TDI
#'
#' Index values for diatom species included in the TDI index
#'
#' @format A data frame with the ecological values for 3445 species
#' @docType data
#' @usage data(tdi)
#' @encoding UTF-8
#' @source \url{https://doi.org/10.1007/BF00003802}
#' @references Kelly, M. G., & Whitton, B. A. (1995). The trophic diatom index: a new index for monitoring eutrophication in rivers. Journal of Applied Phycology, 7(4), 433-444.
"tdi"
