% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diat_vandam.R
\encoding{UTF-8}
\name{diat_vandam}
\alias{diat_vandam}
\title{Calculates ecological information for diatoms based on the Van Dam classification}
\usage{
diat_vandam(resultLoad, vandamReports = TRUE)
}
\arguments{
\item{resultLoad}{The resulting list obtained from the diat_loadData() function}

\item{vandamReports}{Boolean. If set to 'TRUE' the detailed reports for the Van Dam classifications will be reported in the Output. Default = TRUE}
}
\description{
The input for these functions is the resulting dataframe obtained from the diat_loadData() function, to calculate ecological information for diatoms based on the Van Dam classification
Sample data in the examples is taken from:
\itemize{
\item Nicolosi Gelis, María Mercedes; Cochero, Joaquín; Donadelli, Jorge; Gómez, Nora. 2020. "Exploring the use of nuclear alterations, motility and ecological guilds in epipelic diatoms as biomonitoring tools for water quality improvement in urban impacted lowland streams". Ecological Indicators, 110, 105951. https://doi.org/10.1016/j.ecolind.2019.105951
}
Van Dam classification is obtained form:
\itemize{
\item Van Dam, H., Mertens, A., & Sinkeldam, J. (1994). A coded checklist and ecological indicator values of freshwater diatoms from the Netherlands. Netherland Journal of Aquatic Ecology, 28(1), 117-133.
}
}
\examples{
\donttest{
# Example using sample data included in the package (sampleData):
data("diat_sampleData")
# First, the diat_loadData() function has to be called to read the data
# The data will be stored into a list (loadedData)
# And an output folder will be selected through a dialog box if resultsPath is empty
# In the example, a temporary directory will be used in resultsPath
df <- diat_loadData(diat_sampleData, resultsPath = tempdir())
vandamResults <- diat_vandam(df)
}
}
\keyword{bioindicator}
\keyword{biotic}
\keyword{diatom}
\keyword{ecology}
