% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diat_size.R
\encoding{UTF-8}
\name{diat_size}
\alias{diat_size}
\title{Calculate size classes for diatoms}
\usage{
diat_size(resultLoad)
}
\arguments{
\item{resultLoad}{The resulting list obtained from the diat_loadData() function}
}
\description{
The input for these functions is the resulting dataframe obtained from the diat_loadData() function to calculate size classes for diatoms
Sample data in the examples is taken from:
\itemize{
\item Nicolosi Gelis, María Mercedes; Cochero, Joaquín; Donadelli, Jorge; Gómez, Nora. 2020. "Exploring the use of nuclear alterations, motility and ecological guilds in epipelic diatoms as biomonitoring tools for water quality improvement in urban impacted lowland streams". Ecological Indicators, 110, 105951. https://doi.org/10.1016/j.ecolind.2019.105951
}
Size class classification is obtained from:
\itemize{
\item Rimet F. & Bouchez A., 2012. Life-forms, cell-sizes and ecological guilds of diatoms in European rivers. Knowledge and management of aquatic ecosystems, 406: 1-14. DOI:10.1051/kmae/2012018
}
}
\examples{
\donttest{
# Example using sample data included in the package (sampleData):
data("diat_sampleData")
# First, the diat_loadData() function has to be called to read the data
# The data will be stored into a list (loadedData)
# And an output folder will be selected through a dialog box if resultsPath is empty
# In the example, a temporary directory will be used in resultsPath
df <- diat_loadData(diat_sampleData, resultsPath = tempdir())
sizeResults <- diat_size(df)
}
}
\keyword{bioindicator}
\keyword{biotic}
\keyword{diatom}
\keyword{ecology}
