% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_kegg.R
\name{.data_read}
\alias{.data_read}
\title{.data_read}
\usage{
.data_read(path = path, date = date, release = release)
}
\arguments{
\item{path}{character. A character string describing the path to write out KEGG
API data sets. If not provided, defaults to current working directory.}

\item{date}{character. A character string describing the date that was used to
time stamp files from previous call. Must be formatted like YYYY-MM-DD.}

\item{release}{character. A character string describing the KEGG release that was used to
time stamp files from previous call (e.g. "90" or "92")}
}
\value{
kegg_out: A named list of the data pulled from kegg api when the
function was run. This may be different if the function is run at
different times. For reproducible results, use text files generated
by function that include the date they were pulled.
}
\description{
This function reads in the text files generated from a previous
\code{get_kegg} call and saves them as a names list formatted for down
stream analysis.
}
