% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dilp_functions.R
\name{dilp_outliers}
\alias{dilp_outliers}
\title{Identify outlier specimens}
\usage{
dilp_outliers(specimen_data)
}
\arguments{
\item{specimen_data}{Processed specimen level leaf physiognomic data.  The
structure should match the structure of the output from \code{\link[=dilp_processing]{dilp_processing()}}}
}
\value{
A 4 by X data frame. Each row represents one of the DiLP parameters,
and the specimens that are outliers for that parameter.
}
\description{
\code{dilp_outliers()} will typically only be called internally by \code{\link[=dilp]{dilp()}}.
However, it can be used on its own to locate specimens that may have been
misreported or measured incorrectly.  \code{dilp_outliers()} returns a data frame
listing specimens that have unusually high or low values for the four key
parameters used in DiLP analyses.  If flagged, it may be worth taking a look at the
raw measurements and evaluating if the specimen should be used.
}
\examples{
# Check for outliers in the provided McAbeeExample dataset. Each
# of these outliers has been manually re-examined and was found acceptable.
dilp_dataset <- dilp_processing(McAbeeExample)
dilp_outliers <- dilp_outliers(dilp_dataset)
dilp_outliers
}
