% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{physiognomy_calibration_data}
\alias{physiognomy_calibration_data}
\title{Physiognomy Calibration Data}
\format{
\subsection{\code{physiognomy_calibration_data}}{

A data frame with 92 rows and 12 columns:
\describe{
\item{Site}{Locality name}
\item{Leaf.area}{Average leaf area at site}
\item{FDR}{Feret diameter:Feret length. Describes leaf linearity compared to a circle}
\item{Perimeter.ratio}{Ratio - Raw blade perimeter:Internal raw blade perimeter}
\item{TC.P}{Ratio - Tooth count:Perimeter}
\item{TC.IP}{Ratio - Tooth count:Internal perimeter}
\item{Avg.TA}{Average area of a primary tooth}
\item{TA.BA}{Ratio - Tooth area:Blade area}
\item{TA.P}{Ratio - Tooth area:Perimeter}
\item{TA.IP}{Ratio - Tooth area:Internal perimeter}
\item{TC.BA}{Ratio - Tooth count:Blade area}
\item{Margin}{Percentage of untoothed species at the site}
}
}
}
\source{
Peppe et al. 2011
}
\usage{
physiognomy_calibration_data
}
\description{
Leaf physiognomic data taken from the modern localities used to calibrate the DiLP model
}
\references{
\itemize{
\item Peppe, D.J., Royer, D.L., Cariglino, B., Oliver, S.Y., Newman, S., Leight, E., Enikolopov, G., Fernandez-Burgos, M., Herrera, F., Adams, J.M., Correa, E., Currano, E.D., Erickson, J.M., Hinojosa, L.F., Hoganson, J.W., Iglesias, A., Jaramillo, C.A., Johnson, K.R., Jordan, G.J., Kraft, N.J.B., Lovelock, E.C., Lusk, C.H., Niinemets, Ü., Peñuelas, J., Rapson, G., Wing, S.L. and Wright, I.J. (2011), Sensitivity of leaf size and shape to climate: global patterns and paleoclimatic applications. New Phytologist, 190: 724-739. https://doi.org/10.1111/j.1469-8137.2010.03615.x
}
}
\keyword{datasets}
