% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_yq.R
\name{format_yq}
\alias{format_yq}
\title{Directly Create Formatted Year-Quarter Strings}
\usage{
format_yq(x, q = NULL, format = "iso")
}
\arguments{
\item{x, q}{Two integer (vectors). \code{q} is optional and the interpretation of
\code{x} will depend on whether \code{q} is supplied or not:
\itemize{
\item if only \code{x} is supplied, \code{x} will be passed to \code{\link[=as_date_yq]{as_date_yq()}}
(e.g. \code{x = 20161} means first quarter of 2016)
\item if \code{x} and \code{q} are supplied, \code{x} is interpreted as year and \code{q} as
quarter.
}}

\item{format}{A scalar character, valid values are: \code{"iso"}, \code{"short"}, and
\code{"shorter"}}
}
\value{
A character vector
}
\description{
Directly Create Formatted Year-Quarter Strings
}
\examples{

format_yq(2015, 1)
format_yq(20151, format = "short")
format_yq(20151, format = "shorter")

}
\seealso{
\code{\link[=format.date_yq]{format.date_yq()}}

Other yq convenience functions: \code{\link{first_day_yq}}
}
\concept{yq convenience functions}
