% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastmap2.R
\name{fastmap2}
\alias{fastmap2}
\alias{[[.fastmap2}
\alias{$.fastmap2}
\alias{[[<-.fastmap2}
\alias{$<-.fastmap2}
\alias{[.fastmap2}
\alias{[<-.fastmap2}
\alias{names.fastmap2}
\alias{print.fastmap2}
\alias{length.fastmap2}
\alias{as.list.fastmap2}
\title{A Wrapper for \code{fastmap::fastmap}}
\usage{
fastmap2(missing_default = NULL)

\method{[[}{fastmap2}(x, name)

\method{$}{fastmap2}(x, name)

\method{[[}{fastmap2}(x, name) <- value

\method{$}{fastmap2}(x, name) <- value

\method{[}{fastmap2}(x, i, j = NULL, ...)

\method{[}{fastmap2}(x, i, j = NULL, ...) <- value

\method{names}{fastmap2}(x)

\method{print}{fastmap2}(x, ...)

\method{length}{fastmap2}(x)

\method{as.list}{fastmap2}(x, recursive = FALSE, ...)
}
\arguments{
\item{missing_default}{passed to \code{fastmap::fastmap}}

\item{x}{a \code{'fastmap2'} object}

\item{name}{name, or key of the value}

\item{value}{any R object}

\item{i, j}{vector of names}

\item{...}{passed to other methods}

\item{recursive}{whether to recursively apply \code{\link[base]{as.list}}}
}
\value{
A list of \code{'fastmap2'} instance
}
\description{
\code{\link[fastmap]{fastmap}}
provides a key-value store where the keys are strings and the
values are any R objects. It differs from normal environment that
\code{\link[fastmap]{fastmap}} avoids memory leak. \code{fastmap2}
is a wrapper for \code{fastmap}, which provides several generic
functions such that it has similar behaviors to lists or
environments
}
\examples{

## --------------------------- Basic Usage --------------------------
map <- fastmap2()
map$a = 1
map$b = 2
print(map)

map[c('a', 'b')]
# Alternative way
map['a', 'b']

map[c('c', 'd')] <- 3:4
# or
map['e', 'f'] <- 5:6

# The order is not guaranteed, unless sort=TRUE
as.list(map)
as.list(map, sort=TRUE)

names(map)
length(map)

## ----------------------- NULL value handles -----------------------
map$b <- NULL
names(map)   # 'b' still exists!
as.list(map) # 'b' is NULL, but still there

# to remove 'b', you have to use `@remove` method
map$`@remove`('b')

## ---------------- Native fastmap::fastmap methods -----------------

# whether map has 'a'
map$`@has`('a')

# Remove a name from list
map$`@remove`('a')

# remove all from list
map$`@reset`()
print(map)

}
