% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_label_predict.R
\name{ClusterLabelPredict}
\alias{ClusterLabelPredict}
\title{Predict the cluster labels of some new data.}
\usage{
ClusterLabelPredict(dpobj, newData)
}
\arguments{
\item{dpobj}{Fitted Dirichlet Process}

\item{newData}{New data to have cluster labels predicted.}
}
\value{
A list of the predicted cluster labels of some new unseen data.
}
\description{
Given a fitted Dirichlet process object and some new data use this function to predict what clusters the new data belong to and associated cluster parameters.
}
\examples{
y <- rnorm(10)
dp <- DirichletProcessGaussian(y)
dp <- Fit(dp, 5)
newY <- rnorm(10, 1)
pred <- ClusterLabelPredict(dp, newY)

}
