% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burn.R
\name{Burn}
\alias{Burn}
\title{Add burn-in to a dirichletprocess object}
\usage{
Burn(dpobj, niter)
}
\arguments{
\item{dpobj}{A dirichletprocess object.}

\item{niter}{Number of iterations to burn.}
}
\value{
A dirichletprocess object where all chain objects have the first
  \code{niter} iterations are removed.
}
\description{
Add burn-in to a dirichletprocess object
}
\examples{
dp <- Fit(DirichletProcessGaussian(rnorm(10)), 100)
DiagnosticPlots(dp)
burned_dp <- Burn(dp, 50)
DiagnosticPlots(burned_dp)
}
