% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{getCovariateRasters}
\alias{getCovariateRasters}
\title{Get a RasterStack of covariates from a folder containing .tif files}
\usage{
getCovariateRasters(directory, file_pattern = ".tif$", shape)
}
\arguments{
\item{directory}{Filepath to the directory containing the rasters.}

\item{file_pattern}{Pattern the filenames must match. Default is all files ending in .tif .}

\item{shape}{An object with an extent that the rasters will be cropped to.}
}
\value{
A RasterStack of the raster files in the directory
}
\description{
Looks in a specified folder for raster files. Returns a RasterStack of the rasters cropped to the extent specified by the shape parameter.
}
\examples{
\dontrun{
  getCovariateRasters('/home/rasters', '.tif$', shape)
 }

}
