% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npdf.R
\name{npdf_cox}
\alias{npdf_cox}
\title{Cox model for grouped survival data with nonparametric discrete shared frailties}
\usage{
npdf_cox(formula, groups, data, K = 2, estK = TRUE,
  criterion = "BIC", eps_conv = 10^-4, se_method = c("louis",
  "exact"))
}
\arguments{
\item{formula}{A formula expression in conventional R linear modelling
syntax. The response must be a survival time constructed by the
\code{\link{Surv}} function from the \pkg{survival} package, and
any covariates are given on the right-hand
side.  For example,

\code{Surv(time, dead) ~ age + sex}

Only \code{Surv} objects of \code{type="right"} are supported, corresponding to right-censored observations.}

\item{groups}{name of the variable which indicates the group in which each individual belongs (e.g. the hospital that the individual is treated in).  This can be integer, factor or character.  The name should be unquoted.}

\item{data}{A data frame in which to find variables supplied in
\code{formula}.  If not given, the variables should be in the working
environment.}

\item{K}{initial number of latent populations, or clusters of groups which have the same discrete frailty.}

\item{estK}{If \code{TRUE} (the default) then
multiple models are fitted with number of latent groups ranging from 1 to \code{K}.  The "best fitting" model according to the criterion specified in \code{criterion} is then highlighted when printing the object returned by this function.

If \code{FALSE} then the number of latent populations is fixed at \code{K}.}

\item{criterion}{Criterion used to choose the best-fitting model to highlight when \code{estK} is \code{TRUE}.

\code{"Laird"} for the Laird criterion. Running from K latent populations to 1 latent population, this criterion selects the maximum number of latent populations that are non empty as the best K.

\code{"AIC"} for Akaike's information criterion.

\code{"BIC"} for the Bayesian information criterion (the default).}

\item{eps_conv}{convergence tolerance for the EM algorithm.}

\item{se_method}{Method or methods used to compute the standard errors.  A character vector containing one or more of the following:

\code{"louis"} The method of Louis (1982) based on an approximation to the information matrix.

\code{"exact"} In this method the standard errors are computed directly from the observed information matrix obtained by analytic differentiation.

\code{"numeric"} This method uses numerical differentiation to approximate the information matrix, and is substantially slower.

By default this is \code{c("louis","exact")} because these two methods are equally fast. So that SEs from both these two methods are calculated and presented.   Set \code{se_method=NULL} to compute no standard errors.}
}
\value{
If \code{estK=FALSE} this returns a list of class \code{npdf} which includes information about the model fit, including estimates and standard errors.

If \code{estK=TRUE} this returns a list of class \code{npdflist}.  This has an element \code{models} that contains a list of length \code{K}, with one component of class \code{npdf} for each fitted model.

\code{comparison} is a matrix composed of \code{K} rows and 5 columns (\code{K}, \code{K_fitted}, \code{llik}, \code{AIC}, \code{BIC}). \code{K_fitted} is the number of estimated latent populations, which can be equal to or less than \code{K}. \code{llik} stands for log-likelihood, \code{AIC} for Akaike Information Criterion and \code{BIC} for Bayesian Information Criterion.

\code{Kopt} is optimal model under each criterion.

\code{criterion} is the preferred criterion.

In either case, the data frame used for the fit (the "model frame") is appended as a component \code{mf}.
}
\description{
This function fits a Cox proportional hazards model to grouped survival data, where the shared group-specific frailties have a nonparametric discrete distribution.  An EM algorithm is used to maximise the marginal partial likelihood.
}
\examples{
test <- npdf_cox( Surv(time, status) ~ x, groups=family, data=weibdata2030, K = 4, eps_conv=10^-4)
test    # optimal model (by all criteria) has 2 latent populations
test$models[[1]] # examine alternative model with 1 latent population

}
\references{
Gasperoni, F., Ieva, F., Paganoni, A.M., Jackson, C. and Sharples, L. (2018). Nonparametric frailty Cox models for hierarchical time-to-event data. \emph{Biostatistics}.

Laird, N. (1978). Nonparametric maximum likelihood estimation of a mixing distribution. \emph{Journal of the American Statistical Association}, 73(364), 805–811.

Louis, T. A. (1982). Finding the observed information matrix when using the EM algorithm. \emph{Journal of the Royal Statistical Society. Series B}, 44(2), 226–233.
}
