\name{contributor_pairs}
\alias{contributor_pairs}
\alias{print.contrib_pairs}
\title{Contributor pairs from a 2 person mixture}
\description{Get all possible contributor pairs from a 2 person mixture}
\usage{
  contributor_pairs(mixture)
  \method{print}{contrib_pairs}(x, \dots)
}
\arguments{
  \item{mixture}{A list of integer vectors. The k'th element in the list is an integer vector with the alleles in the mixture at locus k.}
  \item{x}{A \code{contrib_pairs} object.}
  \item{\dots}{Not used.}
}
\value{
  A \code{contrib_pairs} object that is a unordered list of pairs. Note, that contributor order is disregarded so that each contributor pair is only present once (and not twice as would be the case if taking order into consideration). See example usage at \code{\link{rank_contributor_pairs}}.
}
\author{
  Mikkel Meyer Andersen <mikl@math.aau.dk>
}

\seealso{
\code{\link{rank_contributor_pairs}}
\code{\link{generate_mixture}}
\code{\link{disclapmix-package}}
\code{\link{disclapmix}}
\code{\link{disclapmixfit}}
\code{\link{clusterprob}}
\code{\link{predict.disclapmixfit}}
\code{\link{print.disclapmixfit}}
\code{\link{summary.disclapmixfit}}
\code{\link{simulate.disclapmixfit}}
\code{\link{haplotype_diversity}}
\code{\link[disclap:disclap-package]{disclap}}
}
\keyword{mixture}
\keyword{separation}
\keyword{deconvolution}
