% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_fit.R
\name{plot,market_fit,ANY-method}
\alias{plot,market_fit,ANY-method}
\title{Plots the fitted model.}
\usage{
\S4method{plot}{market_fit,ANY}(x, subject, time, ...)
}
\arguments{
\item{x}{A model object.}

\item{subject}{A vector of subject identifiers to be used in the
visualization.}

\item{time}{A vector of time identifiers to be used in the visualization.}

\item{...}{Additional parameter to be used for styling the figure.
Specifically \code{xlab}, \code{ylab}, and \code{main} are currently
handled by the function.}
}
\description{
Displays a graphical illustration of the passed fitted model object. The
function creates a scatter plot of quantity-price pairs for the records
corresponding to the given subject and time identifiers. Then, it plots
the average fitted demand and supply quantities for the same data subset
letting prices vary between the minimum and maximum price
points observed in the data subset.
}
\examples{
\donttest{
# estimate a model using the houses dataset
fit <- diseq_deterministic_adjustment(
  HS | RM | ID | TREND ~
  RM + TREND + W + CSHS + L1RM + L2RM + MONTH |
  RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(),  correlated_shocks = FALSE,
  estimation_options = list(control = list(maxit = 1e+6)))

# show model's illustration plot
plot(fit)
}
}
