% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.utilities.R
\name{add.tree}
\alias{add.tree}
\alias{get.tree}
\alias{remove.tree}
\title{Add, get or remove tree}
\usage{
add.tree(data, tree)
}
\arguments{
\item{data}{A \code{dispRity} object.}

\item{tree}{A \code{phylo} or \code{mutiPhylo} object.}
}
\description{
Adding, extracting or removing the tree component from a \code{dispRity} object
}
\examples{
## Loading a dispRity object
data(disparity)
## Loading a tree
data(BeckLee_tree)

## Removing  the tree from the dispRity object
(tree_data <- remove.tree(disparity))

## Extracting the tree
get.tree(tree_data) # is null

## Adding a tree to the disparity object
tree_data <- add.tree(tree_data, tree = BeckLee_tree)

## Extracting the tree
get.tree(tree_data) # is a "phylo" object

}
\seealso{
\code{\link{custom.subsets}}, \code{\link{chrono.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity}}.
}
\author{
Thomas Guillerme
}
