% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{plot.bootstrap_f2}
\alias{plot.bootstrap_f2}
\title{Plot of the bootstrap f2 simulation}
\usage{
\method{plot}{bootstrap_f2}(x, ...)
}
\arguments{
\item{x}{An object of class \sQuote{\code{bootstrap_f2}} returned by the
\code{\link{bootstrap_f2}()} function.}

\item{...}{Further arguments passed to or from other methods or arguments
that can be passed down to the \code{\link[boot]{plot.boot}()} function.}
}
\value{
The \sQuote{\code{bootstrap_f2}} object passed to the \code{x}
parameter is returned invisibly.
}
\description{
This is a method for the function \code{plot()} for objects of class
\sQuote{\code{bootstrap_f2}}.
}
\details{
The element \code{Boot} of the \sQuote{\code{bootstrap_f2}} object
that is returned by the function \code{\link{bootstrap_f2}()} is an object
of class \sQuote{\code{boot}}, generated by the function
\code{\link[boot]{boot}()} from the \sQuote{\code{boot}} package. Thus, the
corresponding \code{plot} method is used. Arguments to the
\code{\link[boot]{plot.boot}()} function can be passed via the \code{...}
parameter. In addition to making the plot the function prints the result of
Shah's lower 90\% BCa confidence interval to the console.
}
\examples{
# Bootstrap assessment of data (two groups) by aid of bootstrap_f2() function
# by using 'rand_mode = "complete"' (the default, randomisation of complete
# profiles)
bs1 <- bootstrap_f2(data = dip2[dip2$batch \%in\% c("b0", "b4"), ],
                    tcol = 5:8, grouping = "batch", rand_mode = "complete",
                    rr = 200, new_seed = 421, use_ema = "no")

\dontrun{
  pbs1 <- plot(bs1)

  # The plot() function returns the 'plot_mztia' object invisibly.
  class(bs1)
  class(pbs1)
}

# Use of 'rand_mode = "individual"' (randomisation per time point)
bs2 <- bootstrap_f2(data = dip2[dip2$batch \%in\% c("b0", "b4"), ],
                    tcol = 5:8, grouping = "batch", rand_mode = "individual",
                    rr = 200, new_seed = 421, use_ema = "no")

\dontrun{
  plot(bs2)
}
}
\seealso{
\code{\link{bootstrap_f2}}, \code{\link[boot]{boot}},
\code{\link[boot]{plot.boot}}, \code{\link[utils]{methods}}.
}
