% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\docType{package}
\name{distanceto}
\alias{distanceto}
\alias{_PACKAGE}
\alias{distanceto-package}
\title{distance-to}
\description{
The \code{distanceto} package is designed to quickly sample distances from points
features to other vector layers. Normally the approach for calculating distance
to (something) involves generating distance surfaces using raster based approaches
eg. \code{raster::distance} or \code{gdal_proximity} and subsequently point sampling these
surfaces. Since raster based approaches are a costly method that frequently leads
to memory issues or long and slow run times with high resolution data or large
study sites, we have opted to compute these distances using vector based
approaches. As a helper, there's a decidedly low-res raster based approach for
visually inspecting your region's distance surface. But the workhorse is
\code{distance_to}.
}
\details{
The \code{distanceto} package provides two functions:
\itemize{
\item \code{distance_to}
\item \code{distance_raster}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/robitalec/distance-to}
  \item \url{https://robitalec.github.io/distance-to/}
  \item Report bugs at \url{https://github.com/robitalec/distance-to/issues}
}

}
\author{
\strong{Maintainer}: Alec L. Robitaille \email{robit.alec@gmail.com} (\href{https://orcid.org/0000-0002-4706-1762}{ORCID})

}
