% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leastCostPathNoBlocks.R
\name{leastCostPathNoBlocks}
\alias{leastCostPathNoBlocks}
\title{Extracts the least-cost from a least cost matrix by trimming blocks.}
\usage{
leastCostPathNoBlocks(
  least.cost.path = NULL,
  parallel.execution = TRUE
  )
}
\arguments{
\item{least.cost.path}{dataframe produced by \code{\link{leastCostPath}}.}

\item{parallel.execution}{boolean, if \code{TRUE} (default), execution is parallelized, and serialized if \code{FALSE}.}
}
\value{
A named list with least cost values.
}
\description{
Extracts the minimum cost of a least-cost path by trimming blocks (straight segments of the path that appear in highly dissimilar regions of the sequences). Blocks inflate psi values when two sequences are similar but have very different numbers of rows. This function is for internal use of other functions in the package.
}
\examples{

\donttest{

#'#loading data
data(sequenceA)
data(sequenceB)

#preparing datasets
AB.sequences <- prepareSequences(
 sequence.A = sequenceA,
 sequence.A.name = "A",
 sequence.B = sequenceB,
 sequence.B.name = "B",
 merge.mode = "complete",
 if.empty.cases = "zero",
 transformation = "hellinger"
 )

#computing distance matrix
AB.distance.matrix <- distanceMatrix(
 sequences = AB.sequences,
 grouping.column = "id",
 method = "manhattan",
 parallel.execution = FALSE
 )

#computing least cost matrix
AB.least.cost.matrix <- leastCostMatrix(
 distance.matrix = AB.distance.matrix,
 diagonal = FALSE,
 parallel.execution = FALSE
 )

AB.least.cost.path <- leastCostPath(
 distance.matrix = AB.distance.matrix,
 least.cost.matrix = AB.least.cost.matrix,
 parallel.execution = FALSE
 )

AB.least.cost.path.nb <- leastCostPathNoBlocks(
 least.cost.path = AB.least.cost.path,
 parallel.execution = FALSE
 )

}

}
