% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testNegativeSkew}
\alias{testNegativeSkew}
\alias{checkNegativeSkew}
\alias{assertNegativeSkew}
\title{assert/check/test/NegativeSkew}
\usage{
testNegativeSkew(
  object,
  errormsg = paste(object$short_name, "is not negative skew")
)

checkNegativeSkew(
  object,
  errormsg = paste(object$short_name, "is not negative skew")
)

assertNegativeSkew(
  object,
  errormsg = paste(object$short_name, "is not negative skew")
)
}
\arguments{
\item{object}{Distribution}

\item{errormsg}{custom error message to return if assert/check fails}
}
\value{
If check passes then \code{assert} returns invisibly and \code{test}/\code{check}
  return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
  an error message as string, \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if Distribution is negative skew.
}
\examples{
testNegativeSkew(Binomial$new())

}
