% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{cdf.Weibull}
\alias{cdf.Weibull}
\title{Evaluate the cumulative distribution function of a Weibull distribution}
\usage{
\method{cdf}{Weibull}(d, x, ...)
}
\arguments{
\item{d}{A \code{Weibull} object created by a call to \code{\link[=Weibull]{Weibull()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the cumulative distribution function of a Weibull distribution
}
\examples{

set.seed(27)

X <- Weibull(0.3, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other Weibull distribution: \code{\link{pdf.Weibull}},
  \code{\link{quantile.Weibull}},
  \code{\link{random.Weibull}}
}
\concept{Weibull distribution}
