% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZINegativeBinomial.R
\name{ZINegativeBinomial}
\alias{ZINegativeBinomial}
\title{Create a zero-inflated negative binomial distribution}
\usage{
ZINegativeBinomial(mu, theta, pi)
}
\arguments{
\item{mu}{Location parameter of the negative binomial component of the distribution.
Can be any positive number.}

\item{theta}{Overdispersion parameter of the negative binomial component of the distribution.
Can be any positive number.}

\item{pi}{Zero-inflation probability, can be any value in \verb{[0, 1]}.}
}
\value{
A \code{ZINegativeBinomial} object.
}
\description{
Zero-inflated negative binomial distributions are frequently used to model counts
with overdispersion and many zero observations.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail.

In the following, let \eqn{X} be a zero-inflated negative binomial random variable with parameters
\code{mu} = \eqn{\mu} and \code{theta} = \eqn{\theta}.

\strong{Support}: \eqn{\{0, 1, 2, 3, ...\}}{{0, 1, 2, 3, ...}}

\strong{Mean}: \eqn{(1 - \pi) \cdot \mu}

\strong{Variance}: \eqn{(1 - \pi) \cdot \mu \cdot (1 + (\pi + 1/\theta) \cdot \mu)}

\strong{Probability mass function (p.m.f.)}:

\deqn{
    P(X = k) = \pi \cdot I_{0}(k) + (1 - \pi) \cdot f(k; \mu, \theta)
  }{
    P(X = k) = \pi \cdot I_{0}(k) + (1 - \pi) \cdot f(k; \mu, \theta)
  }

where \eqn{I_{0}(k)} is the indicator function for zero and
\eqn{f(k; \mu, \theta)} is the p.m.f. of the \code{\link{NegativeBinomial}}
distribution.

\strong{Cumulative distribution function (c.d.f.)}:

\deqn{
    P(X \le k) = \pi + (1 - \pi) \cdot F(k; \mu, \theta)
  }{
    P(X \le k) = \pi + (1 - \pi) \cdot F(k; \mu, \theta)
  }

where \eqn{F(k; \mu, \theta)} is the c.d.f. of the \code{\link{NegativeBinomial}} distribution.

\strong{Moment generating function (m.g.f.)}:

Omitted for now.
}
\examples{
## set up a zero-inflated negative binomial distribution
X <- ZINegativeBinomial(mu = 2.5, theta = 1, pi = 0.25)
X

## standard functions
pdf(X, 0:8)
cdf(X, 0:8)
quantile(X, seq(0, 1, by = 0.25))

## cdf() and quantile() are inverses for each other
quantile(X, cdf(X, 3))

## density visualization
plot(0:8, pdf(X, 0:8), type = "h", lwd = 2)

## corresponding sample with histogram of empirical frequencies
set.seed(0)
x <- random(X, 500)
hist(x, breaks = -1:max(x) + 0.5)
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Categorical}()},
\code{\link{Geometric}()},
\code{\link{HurdleNegativeBinomial}()},
\code{\link{HurdlePoisson}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{NegativeBinomial}()},
\code{\link{Poisson}()},
\code{\link{ZIPoisson}()},
\code{\link{ZTNegativeBinomial}()},
\code{\link{ZTPoisson}()}
}
\concept{discrete distributions}
