% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fhat_conditional.R
\name{Fhat_conditional_}
\alias{Fhat_conditional_}
\title{Weighted empirical cumulative distribution function (ecdf), conditional on one or more variables}
\usage{
Fhat_conditional_(.data, .variables, x, weights)
}
\arguments{
\item{.data}{a data frame}

\item{.variables}{a character vector with one or more column names}

\item{x}{character vector of length one, with the name of the numeric column whose conditional ecdf has to be estimated}

\item{weights}{character vector of length one, indicating the name of the positive numeric column of weights, which will be used in the estimation of the conditional ecdf}
}
\value{
a data frame, with the variables used to condition, the x variable, and columns wsum (aggregated sum of weights, based on unique values of x) and Fhat (the estimated conditional Fhat). In addition to data frame, the object will be of classes grouped_df, tbl_df and tbl (from package dplyr)
}
\description{
Weighted empirical cumulative distribution function (ecdf), conditional on one or more variables
}
\examples{
Fhat_conditional_(mtcars,
                 .variables = c("vs", "am"),
                 x = "mpg",
                 weights = "cyl")
}
