% $Id: dives.Rd 355 2010-09-08 05:22:10Z sluque $
\name{dives}
\docType{data}

\alias{dives}
\alias{divesTDR}

% -------------------------------------------------------------------------

\title{Sample of TDR data from a fur seal}



\description{This data set is meant to show a typical organization of a
  \acronym{TDR} *.csv file, suitable as input for \code{\link{readTDR}},
  or to construct a \code{\link{TDR}} object.  \code{divesTDR} is an
  example \code{\link{TDR}} object.}


\format{

  A comma separated value (csv) file with 69560 \acronym{TDR} readings
  with the following columns:

  \describe{
    \item{date}{Date}

    \item{time}{Time}

    \item{depth}{Depth in m}

    \item{light}{Light level}

    \item{temperature}{Temperature in degrees Celsius}

    \item{speed}{Speed in m/s}
  }

  The data are also provided as a \code{\link{TDR}} object (*.RData
  format) for convenience.

}


\details{

  The data are a subset of an entire \acronym{TDR} record, so they are
  not meant to make valid inferences from this particular
  individual/deployment.

  \code{divesTDR} is a \code{\link{TDR}} object representation of the
  data in \code{dives}.

}


\seealso{\code{\link{readTDR}}, \code{\link{diveStats}}.}


\source{Sebastian P. Luque, Christophe Guinet, John P.Y. Arnould}

% -------------------------------------------------------------------------

\examples{
dives <- read.csv(system.file(file.path("data", "dives.csv"),
                              package="diveMove"),
                  sep=";", na.strings="")
str(dives)

}


\keyword{datasets}
