% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dkanr_settings.R
\name{dkanr_setup}
\alias{dkanr_setup}
\title{Configure default DKAN settings}
\usage{
dkanr_setup(url = "http://demo.getdkan.com", username = NULL,
  password = NULL)
}
\arguments{
\item{url}{A DKAN URL (optional), default: "http://demo.getdkan.com"}

\item{username}{Username (optional, character)}

\item{password}{Password (optional, character)}
}
\description{
Configure default DKAN settings
}
\details{
\code{dkanr_setup} sets DKAN connection details. \code{dkanr} functions
default to use the default URL and API key unless specified explicitly.
}
\examples{
\dontrun{
DKAN users without admin/editor privileges could run:
dkanr_setup(url = "http://demo.getdkan.com")

Privileged DKAN editor/admin users can run:
dkanr_setup(url = "http://demo.getdkan.com", username = "your-username", password = "your-password")

Not specifying the default DKAN URL will reset the DKAN URL to its default
"http://demo.getdkan.com":
dkanr_setup()
}
}
