% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate.R
\name{plot_correlate}
\alias{plot_correlate}
\title{Visualize correlation plot of numerical data}
\usage{
plot_correlate(.data, ...)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_correlate() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.

See vignette("EDA") for an introduction to these concepts.}
}
\description{
The plot_correlate() visualize correlation plot
for find relationship between two numerical variables.
}
\details{
The scope of the visualization is the provide a correlation information.
Since the plot is drawn for each variable, if you specify more than
one variable in the ... argument, the specified number of plots are drawn.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Visualize correlation plot of all numerical variables
plot_correlate(carseats)

# Select the variable to compute
plot_correlate(carseats, Sales, Price)
plot_correlate(carseats, -Sales, -Price)
plot_correlate(carseats, "Sales", "Price")
plot_correlate(carseats, 1)

# Using dplyr::grouped_dt
library(dplyr)

gdata <- group_by(carseats, ShelveLoc, US)
plot_correlate(gdata, "Sales")
plot_correlate(gdata)

# Using pipes ---------------------------------
# Visualize correlation plot of all numerical variables
carseats \%>\%
  plot_correlate()
# Positive values select variables
carseats \%>\%
  plot_correlate(Sales, Price)
# Negative values to drop variables
carseats \%>\%
  plot_correlate(-Sales, -Price)
# Positions values select variables
carseats \%>\%
  plot_correlate(1)
# Positions values select variables
carseats \%>\%
  plot_correlate(-1, -2, -3, -5, -6)

# Using pipes & dplyr -------------------------
# Visualize correlation plot of 'Sales' variable by 'ShelveLoc'
# and 'US' variables.
carseats \%>\%
group_by(ShelveLoc, US) \%>\%
plot_correlate(Sales)

# Extract only those with 'ShelveLoc' variable level is "Good",
# and visualize correlation plot of 'Sales' variable by 'Urban'
# and 'US' variables.
carseats \%>\%
 filter(ShelveLoc == "Good") \%>\%
 group_by(Urban, US) \%>\%
 plot_correlate(Sales)
}
\seealso{
\code{\link{plot_outlier}}.
}
