% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{diagnose_outlier.tbl_dbi}
\alias{diagnose_outlier.tbl_dbi}
\title{Diagnose outlier of numerical variables in the DBMS}
\usage{
\method{diagnose_outlier}{tbl_dbi}(.data, ..., in_database = FALSE,
  collect_size = Inf)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, diagnose_outlier() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context
where column names represent column positions.
They support unquoting and splicing.}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory. Not yet supported in_database = TRUE.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.}
}
\value{
an object of tbl_df.
}
\description{
The diagnose_outlier() produces outlier information
for diagnosing the quality of the numerical(INTEGER, NUMBER, etc.) column 
of the DBMS table through tbl_dbi.
}
\details{
The scope of the diagnosis is the provide a outlier information.
If the number of outliers is small and the difference between the averages
including outliers and the averages not including them is large,
it is necessary to eliminate or replace the outliers.
}
\section{Outlier Diagnostic information}{

The information derived from the numerical data diagnosis is as follows.

\itemize{
\item variables : variable names
\item outliers_cnt : count of outliers
\item outliers_ratio : percent of outliers
\item outliers_mean : arithmetic average of outliers
\item with_mean : arithmetic average of with outliers
\item without_mean : arithmetic average of without outliers
}

See vignette("diagonosis") for an introduction to these concepts.
}

\examples{
library(dplyr)
library(dbplyr)

# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy carseats to the DBMS with a table named TB_CARSEATS
copy_to(con_sqlite, carseats, name = "TB_CARSEATS", overwrite = TRUE)

# Using pipes ---------------------------------
# Diagnosis of all numerical variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_outlier()
  
# Positive values select variables, and In-memory mode and collect size is 200
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_outlier(Sales, Income, collect_size = 200)
  
# Negative values to drop variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_outlier(-Sales, -Income)
  
# Positions values select variables
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_outlier(5)
# Positions values select variables

con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_outlier(-1, -5)

# Using pipes & dplyr -------------------------
# outlier_ratio is more than 1\%
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  diagnose_outlier()  \%>\%
  filter(outliers_ratio > 1)
  
}
\seealso{
\code{\link{diagnose_outlier.data.frame}}, \code{\link{diagnose.tbl_dbi}}, \code{\link{diagnose_category.tbl_dbi}}, \code{\link{diagnose_numeric.tbl_dbi}}.
}
