% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{eda_report.tbl_dbi}
\alias{eda_report.tbl_dbi}
\title{Reporting the information of EDA for table of the DBMS}
\usage{
\method{eda_report}{tbl_dbi}(.data, target = NULL, output_format = c("pdf",
  "html"), output_file = NULL, output_dir = tempdir(),
  in_database = FALSE, collect_size = Inf, ...)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{target}{target variable.}

\item{output_format}{report output type. Choose either "pdf" and "html".
"pdf" create pdf file by knitr::knit().
"html" create html file by rmarkdown::render().}

\item{output_file}{name of generated file. default is NULL.}

\item{output_dir}{name of directory to generate report file. default is tempdir().}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory. Not yet supported in_database = TRUE.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.}

\item{...}{arguments to be passed to methods.}
}
\description{
The eda_report() report the information of Exploratory
data analysis for object inheriting from the DBMS table through tbl_dbi
}
\details{
Generate generalized data EDA reports automatically.
You can choose to output to pdf and html files.
This is useful for EDA a data frame with a large number of variables
than data with a small number of variables.
}
\section{Reported information}{

The EDA process will report the following information:

\itemize{
  \item Introduction
  \itemize{
    \item Information of Dataset
    \item Information of Variables
    \item About EDA Report
  }
  \item Univariate Analysis
  \itemize{
    \item Descriptive Statistics
    \item Normality Test of Numerical Variables
    \itemize{
      \item Statistics and Visualization of (Sample) Data
    }
  }
  \item Relationship Between Variables
  \itemize{
    \item Correlation Coefficient
    \itemize{
      \item Correlation Coefficient by Variable Combination
      \item Correlation Plot of Numerical Variables
    }
  }
  \item Target based Analysis
  \itemize{
    \item Gruoped Descriptive Statistics
    \itemize{
      \item Gruoped Numerical Variables
      \item Gruoped Categorical Variables
    }
    \item Gruoped Relationship Between Variables
    \itemize{
      \item Grouped Correlation Coefficient
      \item Grouped Correlation Plot of Numerical Variables
    }
  }
}

See vignette("EDA") for an introduction to these concepts.
}

\examples{
\donttest{
library(dplyr)
library(dbplyr)

# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy carseats to the DBMS with a table named TB_CARSEATS
copy_to(con_sqlite, carseats, name = "TB_CARSEATS", overwrite = TRUE)

## target variable is categorical variable
# reporting the EDA information
# create pdf file. file name is EDA_Report.pdf
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report(US)

# create pdf file. file name is EDA.pdf
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report("US", output_file = "EDA.pdf")

# create html file. file name is EDA_Report.html
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report("US", output_format = "html")

# create html file. file name is EDA.html
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report(US, output_format = "html", output_file = "EDA.html")

## target variable is numerical variable
# reporting the EDA information, and collect size is 350
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report(Sales, collect_size = 350)

# create pdf file. file name is EDA2.pdf
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report("Sales", output_file = "EDA2.pdf")

# create html file. file name is EDA_Report.html
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report("Sales", output_format = "html")

# create html file. file name is EDA2.html
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report(Sales, output_format = "html", output_file = "EDA2.html")

## target variable is null
# reporting the EDA information
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report()

# create pdf file. file name is EDA2.pdf
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report(output_file = "EDA2.pdf")

# create html file. file name is EDA_Report.html
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report(output_format = "html")

# create html file. file name is EDA2.html
con_sqlite \%>\% 
  tbl("TB_CARSEATS") \%>\% 
  eda_report(output_format = "html", output_file = "EDA2.html")
}

}
\seealso{
\code{\link{eda_report.data.frame}}.
}
