% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{plot_bar_category}
\alias{plot_bar_category}
\alias{plot_bar_category.data.frame}
\alias{plot_bar_category.grouped_df}
\title{Plot bar chart of categorical variables}
\usage{
plot_bar_category(.data, ...)

\method{plot_bar_category}{data.frame}(
  .data,
  ...,
  top = 10,
  add_character = TRUE,
  title = "Frequency by levels of category",
  each = FALSE,
  typographic = TRUE
)

\method{plot_bar_category}{grouped_df}(
  .data,
  ...,
  top = 10,
  add_character = TRUE,
  title = "Frequency by levels of category",
  each = FALSE,
  typographic = TRUE
)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}} or a \code{\link{grouped_df}}.}

\item{\dots}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_bar_category() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context where
column names represent column positions.
They support unquoting and splicing.}

\item{top}{an integer. Specifies the upper top rank to extract.
Default is 10.}

\item{add_character}{logical. Decide whether to include text variables in the
diagnosis of categorical data. The default value is TRUE, which also includes character variables.}

\item{title}{character. a main title for the plot.}

\item{each}{logical. Specifies whether to draw multiple plots on one screen. 
The default is FALSE, which draws multiple plots on one screen.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}
}
\description{
The plot_bar_category() to visualizes the distribution of 
categorical data by level or relationship to specific numerical data by level.
}
\details{
The distribution of categorical variables can be understood by 
comparing the frequency of each level. The frequency table helps with this. 
As a visualization method, a bar graph can help you understand 
the distribution of categorical data more easily than a frequency table.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA
set.seed(123)
carseats$Test <- sample(LETTERS[1:15], 400, replace = TRUE)
carseats$Test[1:30] <- NA

# Visualization of all numerical variables
plot_bar_category(carseats)

# Select the variable to diagnose
# plot_bar_category(carseats, "ShelveLoc", "Urban")
# plot_bar_category(carseats, -ShelveLoc, -Urban)

# Visualize the each plots
# plot_bar_category(carseats, each = TRUE)

# Not allow typographic argument
# plot_bar_category(carseats, typographic = FALSE)

# Using pipes ---------------------------------
library(dplyr)

# Plot of all categorical variables
#carseats \%>\%
#   plot_bar_category()

# Visualize just 7 levels of top frequency
carseats \%>\%
  plot_bar_category(top = 7)
   
# Visualize only factor, not character
# carseats \%>\%
#   plot_bar_category(add_character = FALSE) 
  
# Using groupd_df  ------------------------------
carseats \%>\% 
  group_by(ShelveLoc) \%>\% 
  plot_bar_category(top = 5)
  
# carseats \%>\% 
#   group_by(ShelveLoc) \%>\% 
#   plot_bar_category(each = TRUE, top = 5)  
  
}
