% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{transformation_web_report}
\alias{transformation_web_report}
\title{Reporting the information of transformation with html}
\usage{
transformation_web_report(
  .data,
  target = NULL,
  output_file = NULL,
  output_dir = tempdir(),
  browse = TRUE,
  title = "Transformation",
  subtitle = deparse(substitute(.data)),
  author = "dlookr",
  title_color = "gray",
  logo_img = NULL,
  create_date = Sys.time(),
  theme = c("orange", "blue"),
  sample_percent = 100,
  base_family = NULL,
  ...
)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{target}{character. target variable.}

\item{output_file}{name of generated file. default is NULL.}

\item{output_dir}{name of directory to generate report file. default is tempdir().}

\item{browse}{logical. choose whether to output the report results to the browser.}

\item{title}{character. title of report. default is "EDA Report".}

\item{subtitle}{character. subtitle of report. default is name of data.}

\item{author}{character. author of report. default is "dlookr".}

\item{title_color}{character. color of title. default is "gray".}

\item{logo_img}{character. name of logo image file on top left.}

\item{create_date}{Date or POSIXct, character. The date on which the report is generated. 
The default value is the result of Sys.time().}

\item{theme}{character. name of theme for report. support "orange" and "blue". 
default is "orange".}

\item{sample_percent}{numeric. Sample percent of data for performing EDA. 
It has a value between (0, 100]. 100 means all data, and 5 means 5\% of sample data.
This is useful for data with a large number of observations.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}

\item{...}{arguments to be passed to methods.}
}
\value{
No return value. This function only generates a report.
}
\description{
The transformation_web_report() report the information of 
transform numerical variables for object inheriting from data.frame.
}
\details{
Generate transformation reports automatically. 
This is useful for Binning a data frame with a large number of variables 
than data with a small number of variables.
}
\section{Reported information}{

The transformation process will report the following information:

\itemize{
  \item Overview
  \itemize{
    \item Data Structures 
    \item Data Types
    \item Job Informations
  }
  \item Imputation
  \itemize{
    \item Missing Values
    \item Outliers
  }   
  \item Resolving Skewness
  \item Binning
  \item Optimal Binning
}

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}

\examples{
\donttest{
if (FALSE) {
# create html file. file name is Transformation_Report.html
transformation_web_report(heartfailure)

# file name is Transformation.html. and change logo image
logo <- file.path(system.file(package = "dlookr"), "report", "R_logo_html.svg")
transformation_web_report(heartfailure, logo_img = logo, title_color = "black",
  output_file = "Transformation.html")

# file name is ./Transformation.html, "blue" theme and not browse
transformation_web_report(heartfailure, output_dir = ".", target = "death_event", 
  author = "Choonghyun Ryu", output_file = "Transformation.html", 
  theme = "blue", browse = FALSE)
}
}

}
