% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{get_min_alpha}
\alias{get_min_alpha}
\title{Get the minimum alpha level for the permutation test}
\usage{
get_min_alpha(x)
}
\arguments{
\item{x}{A 'dnapath_list' or 'dnapath' object from \code{\link{dnapath}}.}
}
\value{
The minimum alpha level that can be used based on the number
of permutations performed in the analysis.
}
\description{
This method is used internally by several methods to determine the
minimum significance threshold (alpha value) that can be applied to the
permutation p-values obtained in the differential network analysis.
}
\examples{
data(meso)
data(p53_pathways)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   group_labels = meso$groups, n_perm = 5)
get_min_alpha(results) # 1 / (5 + 1) = 0.167
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   group_labels = meso$groups, n_perm = 10)
get_min_alpha(results) # 1 / (10 + 1) = 0.091
}
