% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_generation.R
\name{partition_generation}
\alias{partition_generation}
\title{Unsupervised partition with K selection}
\usage{
partition_generation(data, LOG, clust.algo, k.crit)
}
\arguments{
\item{data}{dataframe to cluster}

\item{LOG}{logical. Should all columns of the dataset be logged before
applying clustering algorithms?}

\item{clust.algo}{vector of strings: name of clustering algorithms to use
(use \code{"km"} for k-means, \code{"kmed"} for K-medians, \code{"hc"} for
\code{hclust()} and/or \code{"mclust"} for \code{mclust()}).}

\item{k.crit}{string. Criterion to select the optimal number of clusters (for
each imputed dataset). Use \code{"ch"} for Calinski and Harabasz criterion
(not available for "\code{mclust}"), \code{"CritCF"} for \code{CritCF} or
\code{bic} for BIC ("\code{mclust}" only).}
}
\value{
a dataframe with one column for each algorithm in \code{clust.algo},
containing the cluster IDs.
}
\description{
Generates a partition using \code{clust.algo} algorithm, with \code{k.crit}
for selecting the number of clusters
}
\examples{
partition_generation(iris[, 1:4], LOG = FALSE,
                     clust.algo = c("km", "hc"), k.crit = "ch")
}
