% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{rowmatch}
\alias{rowmatch}
\title{Row Matching}
\usage{
rowmatch(x, table, nomatch = NA_integer_)
}
\arguments{
\item{x}{a row matrix of doubles, the rows to be matched.}

\item{table}{a row matrix of doubles, the rows to be matched against.}

\item{nomatch}{the value to be returned in the case when no match is found.
Note that it is coerced to \code{integer}.}
}
\value{
\code{rowmatch} returns an integer vector giving the position of the matching row in \code{table} for each row in \code{x}. And \code{nomatch} if there is no matching row.
}
\description{
\code{rowmatch} returns a vector of the positions of (first) matches of the rows of its first argument in the rows of its second.
}
\details{
\code{rowmatch} uses compiled C-code.
}
\examples{
a = as.matrix(expand.grid(as.double(2:3), as.double(3:6)))
a = a[sample(nrow(a)),]
a

b = as.matrix(expand.grid(as.double(3:4), as.double(2:5)))
b = b[sample(nrow(b)),]
b

i = rowmatch(a, b)
i
b[na.omit(i),] # matching rows
a[is.na(i),] # non matching rows
}
\seealso{
\code{\link[base]{match}}
}

