% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\docType{package}
\name{doctest-package}
\alias{doctest}
\alias{doctest-package}
\title{Write testthat tests for your examples, using roxygen tags}
\description{
The doctest package lets you test the code in your "Examples"
section in .Rd files. It uses the roxygen2 and testthat packages.
For more information, see \link{@doctest} and \link{@expect}.
}
\details{
\subsection{Example}{

Here's some \href{https://roxygen2.r-lib.org}{roxygen} documentation for a function:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
#' Fibonacci function 
#' 
#' @param n Integer
#' @return The nth Fibonacci number
#' 
#' @doctest
#'
#' @expect type("integer")
#' fib(2)
#'
#' n <- 6 
#' @expect equal(8)
#' fib(n)
#' 
#' @expect warning("not numeric")
#' fib("a")
#'
#' @expect warning("NA")
#' fib(NA)
fib <- function (n) \{
  if (! is.numeric(n)) warning("n is not numeric")
  ...
\}
}\if{html}{\out{</div>}}

Instead of an \verb{@examples} section, we have a \verb{@doctest} section.

This will create tests like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Generated by doctest: do not edit by hand
# Please edit file in R/<text>

test_that("Doctest: fib", \{
  # Created from @doctest for `fib`
  # Source file: <text>
  # Source line: 7
  expect_type(fib(2), "integer")
  n <- 6
  expect_equal(fib(n), 8)
  expect_warning(fib("a"), "not numeric")
  expect_warning(fib(NA), "NA")
\})
}\if{html}{\out{</div>}}

The .Rd file will be created as normal, with an example section like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\\examples\{
fib(2)

n <- 6 
fib(n)
fib("a")
fib(NA)
\}
}\if{html}{\out{</div>}}
}

\subsection{Usage}{

You can install the development version of doctest like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{devtools::install("hughjonesd/doctest")
}\if{html}{\out{</div>}}

To use doctest in your package, alter its DESCRIPTION file to add the
\code{dt_roclet} roclet to roxygen:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Roxygen: list(roclets = c("collate", "rd", "namespace", 
              "doctest::dt_roclet")) 
}\if{html}{\out{</div>}}

Then use \code{roxygen2::roxygenize()} or \code{devtools::document()} to build
your package documentation.

Doctest is \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://hughjonesd.github.io/doctest/}
  \item Report bugs at \url{https://github.com/hughjonesd/doctest/issues}
}

}
\author{
\strong{Maintainer}: David Hugh-Jones \email{davidhughjones@gmail.com}

}
