% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issues.R
\name{issues}
\alias{issues}
\title{Prints issues found in other functions}
\usage{
issues(res, i = 0, verbose = FALSE)
}
\arguments{
\item{res}{A list returned from \code{diagnose()} or \code{compare()}}

\item{i}{Index or name of column from which to print issues}

\item{verbose}{Specify what issues were found in each column}
}
\description{
Prints messages with issues found in \code{X} (or one of its columns)
  after running either \code{diagnose(X)} or \code{compare(X)}
}
\details{
This function interprets the results from \code{diagnose()} and
  \code{compare()}, and generates a comprehensive report printed as
  messages to the console; for more information about what gets printed
  consult \code{vignette("doctr_diagnose")} or \code{vignette("doctr_examine")}
}
\examples{
\dontrun{
library(tidyverse)
  
# Getting issues from diagnostic
txhousing \%>\% diagnose() \%>\% issues()
  
# Getting issues from comparison
txhousing \%>\% compare(txhousing) \%>\% issues()
  
# Getting issues from specific variable
txhousing \%>\% diagnose() \%>\% issues("inventory", verbose = TRUE)
txhousing \%>\% compare(sample_n(txhousing, 20)) \%>\% issues(1, verbose = TRUE)
}

}
