% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi-s3.r
\name{backend_db}
\alias{backend_db}
\alias{db_analyze}
\alias{db_begin}
\alias{db_commit}
\alias{db_create_index}
\alias{db_create_indexes}
\alias{db_create_table}
\alias{db_data_type}
\alias{db_drop_table}
\alias{db_explain}
\alias{db_has_table}
\alias{db_insert_into}
\alias{db_list_tables}
\alias{db_query_fields}
\alias{db_query_rows}
\alias{db_rollback}
\alias{db_save_query}
\title{Database generics.}
\usage{
db_list_tables(con)

db_has_table(con, table)

db_data_type(con, fields)

db_save_query(con, sql, name, temporary = TRUE, ...)

db_begin(con, ...)

db_commit(con, ...)

db_rollback(con, ...)

db_create_table(con, table, types, temporary = FALSE, ...)

db_insert_into(con, table, values, ...)

db_create_indexes(con, table, indexes = NULL, unique = FALSE, ...)

db_create_index(con, table, columns, name = NULL, unique = FALSE, ...)

db_drop_table(con, table, force = FALSE, ...)

db_analyze(con, table, ...)

db_explain(con, sql, ...)

db_query_fields(con, sql, ...)

db_query_rows(con, sql, ...)
}
\arguments{
\item{con}{A database connection.}

\item{table}{A string, the table name.}

\item{fields}{A list of fields, as in a data frame.}
}
\value{
Usually a logical value indicating success. Most failures should generate
 an error. However, \code{db_has_table()} should return \code{NA} if
 temporary tables cannot be listed with \code{dbListTables} (due to backend
 API limitations for example). As a result, you methods will rely on the
 backend to throw an error if a table exists when it shouldn't.
}
\description{
These generics execute actions on the database. Most generics have a method
for \code{DBIConnection} which typically just call the standard DBI S4
method.
}
\details{
Note, a few backend methods do not call the standard DBI S4 methods including
\itemize{
\item \code{db_data_type}: Calls DBI's \code{dbDataType} for every field
(e.g. data frame column) and returns a vector of corresponding SQL data
types
\item \code{db_save_query}: Builds and executes \code{CREATE [TEMPORARY]
TABLE <table> ...} SQL command.
\item \code{db_create_table}: Builds and executes \code{CREATE [TEMPORARY]
TABLE <table> ...} SQL command.
\item \code{db_create_index}: Builds and executes \code{CREATE INDEX <name>
ON <table>} SQL command.
\item \code{db_drop_table}: Builds and executes \code{DROP TABLE [IF EXISTS]
 <table>} SQL command.
\item \code{db_analyze}: Builds and executes \code{ANALYZE <table>} SQL
command.
\item \code{db_insert_into} and \code{db_explain}: do not have methods
calling corresponding DBI methods. The latter because no underlying DBI S4
method exists and the former because calls to the corresponding DBI S4
method (\code{dbWriteTable}) need to be able to specify an appropriate
combination of values for non-standard \code{append} and \code{overwrite}
arguments.
}

Currently, \code{copy_to} is the only user of \code{db_begin()}, \code{db_commit()},
\code{db_rollback()}, \code{db_create_table()}, \code{db_insert_into()},
\code{db_create_indexes()}, \code{db_drop_table()} and
\code{db_analyze()}. If you find yourself overriding many of these
functions it may suggest that you should just override \code{\link{copy_to}}
instead.
}
\keyword{internal}

