% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{funs}
\alias{funs}
\alias{funs_}
\title{Create a list of functions calls.}
\usage{
funs(...)

funs_(dots, args = list(), env = baseenv())
}
\arguments{
\item{dots, ...}{A list of functions specified by:

  \itemize{
    \item Their name, \code{"mean"}
    \item The function itself, \code{mean}
    \item A call to the function with \code{.} as a dummy parameter,
      \code{mean(., na.rm = TRUE)}
  }}

\item{args}{A named list of additional arguments to be added to all
function calls.}

\item{env}{The environment in which functions should be evaluated.}
}
\description{
\code{funs} provides a flexible way to generate a named list of functions for
input to other functions like \code{summarise_each}.
}
\examples{
funs(mean, "mean", mean(., na.rm = TRUE))

# Overide default names
funs(m1 = mean, m2 = "mean", m3 = mean(., na.rm = TRUE))

# If you have function names in a vector, use funs_
fs <- c("min", "max")
funs_(fs)
}

