% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.r
\name{setops}
\alias{setops}
\alias{intersect}
\alias{union}
\alias{union_all}
\alias{setdiff}
\alias{setequal}
\title{Set operations}
\usage{
intersect(x, y, ...)

union(x, y, ...)

union_all(x, y, ...)

setdiff(x, y, ...)

setequal(x, y, ...)
}
\arguments{
\item{x, y}{objects to perform set function on (ignoring order)}

\item{...}{other arguments passed on to methods}
}
\description{
These functions override the set functions provided in base to make them
generic so that efficient versions for data frames and other tables can be
provided. The default methods call the base versions. Beware that
\code{intersect()}, \code{union()} and \code{setdiff()} remove duplicates.
}
\examples{
mtcars$model <- rownames(mtcars)
first <- mtcars[1:20, ]
second <- mtcars[10:32, ]

intersect(first, second)
union(first, second)
setdiff(first, second)
setdiff(second, first)

union_all(first, second)
setequal(mtcars, mtcars[32:1, ])

# Handling of duplicates:
a <- data.frame(column = c(1:10, 10))
b <- data.frame(column = c(1:5, 5))

# intersection is 1 to 5, duplicates removed (5)
intersect(a, b)

# union is 1 to 10, duplicates removed (5 and 10)
union(a, b)

# set difference, duplicates removed (10)
setdiff(a, b)

# union all does not remove duplicates
union_all(a, b)
}
