% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{hide}
\alias{hide}
\alias{show}
\alias{toggle}
\title{Change the state of a shiny interface element}
\usage{
hide(ids)

show(ids)

toggle(ids, condition = NULL)
}
\arguments{
\item{ids}{Character vector, id(s) of the element to hide/show.}

\item{condition}{Condition to be used for toggling the visibility (TRUE =
visible).}
}
\description{
Those functions can be used to change an elements visibility
status.
}
\note{
If you have trouble with these functions, please make sure that you
either - use any dqshiny element in your UI - load the package with
\code{\link{library}} - use \code{\link{init}} at the beginning of your UI!
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    init(),
    actionButton("hide", "Hide"),
    actionButton("show", "Show"),
    actionButton("toggle", "Toggle"),
    actionButton("toggle_cond", "Toggle Visibility with Condition"),
    actionButton("toggle_all", "Toggle All Visibilities"),
    checkboxInput("condition", "Visible"),
    actionButton("example1", "EXAMPLE1"),
    actionButton("example2", "EXAMPLE2"),
    actionButton("example3", "EXAMPLE3")
  ),
  server = function(input, output) {
    observeEvent(input$hide, hide("example1"))
    observeEvent(input$show, show("example1"))
    observeEvent(input$toggle, toggle("example1"))
    observeEvent(input$toggle_cond,
      toggle("example1", input$condition)
    )
    observeEvent(input$toggle_all,
      toggle(c("example1", "example2", "example3"))
    )
  }
)

}
}
\seealso{
Other js handler: \code{\link{add_class}},
  \code{\link{enable}}
}
\author{
richard.kunze
}
\concept{js handler}
