% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tauSurface.R
\name{plot.tauSurface}
\alias{plot.tauSurface}
\title{Plot method for "tauSurface" objects}
\usage{
\method{plot}{tauSurface}(x, y = NULL, which = c("2d", "3d"), ...)
}
\arguments{
\item{x}{A \code{tauSurface} object returned by \code{\link{getTauSurface}}.}

\item{y}{An optional second \code{tauSurface} object returned by 
\code{\link{getTauSurface}}. If provided, \code{which} argument is ignored 
and a 2d-plot comparing two tau surfaces is produced. Note that the two 
estimates should have been calculated on the same \code{HarbronFit} object. 
Note that this argument can also be used as \code{which}. See examples.}

\item{which}{Whether to show a 3d plot (surface plot) or a 2d plot 
(slice plot). Correspondingly \code{\link{tauPlot3d}} or 
\code{\link{tauPlot2d}} is called.}

\item{...}{Further arguments passed to \code{\link{tauPlot3d}} or 
\code{\link{tauPlot2d}}.}
}
\description{
2D slice and 3D surface plots for the interaction index surface.
}
\examples{
\donttest{
data("checkerboardData", package = "drugCombo")
data1 <- checkerboardData[checkerboardData$exp == 1, ]
fitUniform <- fitModel(data1, model = "uniform")
tauUniform <- getTauSurface(fitUniform)
fitLinear <- fitModel(data1, model = "linear1")
tauLinear <- getTauSurface(fitLinear)
plot(tauUniform)
plot(tauLinear, which = "2d", side = "d2", facetBy = "d1")
plot(tauLinear, which = "3d")
plot(tauUniform, tauLinear, tauNames = c("uniform", "linear"))
plot(tauUniform, tauLinear, continuous2 = FALSE)
}
}
\seealso{
\code{\link{tauPlot3d}}, \code{\link{tauPlot2d}} for the underlying 
functions and their arguments. \code{\link{contour.tauSurface}} for another 
visual representation of the estimated interaction indices.
}
