% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tauSurface.R
\name{tauPlot2d}
\alias{tauPlot2d}
\title{Plot estimated interaction index surface slice along one of the doses}
\usage{
tauPlot2d(
  tauSurface,
  tauSurface2 = NULL,
  side = "d1",
  groupBy = NULL,
  colorBy = groupBy,
  facetBy = "auto",
  continuous = FALSE,
  continuous2 = FALSE,
  addLine = continuous || continuous2,
  funs = NULL,
  funs2 = NULL,
  title = NULL,
  tauNames = NULL,
  digits = 4,
  facetOpts = NULL
)
}
\arguments{
\item{tauSurface}{A \code{tauSurface} object returned by 
\code{\link{getTauSurface}}.}

\item{tauSurface2}{An optional second \code{tauSurface} object returned by 
\code{\link{getTauSurface}}. If provided, a 2d-plot comparing the two tau 
surfaces is produced. Note that the estimates should have been calculated on 
the same \code{HarbronFit} object.}

\item{side}{Data column to use as x-axis: "d1", "d2", "total" or another 
variable from the data in the \code{tauSurface} object.}

\item{groupBy}{Data column to use as grouping. Note that if comparison of two 
surfaces is performed, this will be ignored.}

\item{colorBy}{Data column to use for coloring.}

\item{facetBy}{Whether to facet plots by extra variables used in the tau 
formula ("auto") or manually provided data column(s) to facet by.}

\item{continuous}{Whether continuous type of plot is requested (for 
\code{tauSurface1}). This is automatically detected if used via 
\code{\link{plot.tauSurface}}, but can be overwritten.}

\item{continuous2}{Whether continuous type of plot is requested (for 
\code{tauSurface2}). This is automatically detected if used via 
\code{\link{plot.tauSurface}}, but can be overwritten.}

\item{addLine}{Whether to connect tau estimates for subsequent doses.}

\item{funs}{A list with functions to compute tau surface and confidence 
bands (for \code{tauSurface1}). These are returned by the 
\code{\link{getTauSurface}} and are automatically used when the 
\code{\link{plot.tauSurface}} is called.}

\item{funs2}{A list with functions to compute tau surface and confidence 
bands (for \code{tauSurface2}). These are returned by the 
\code{\link{getTauSurface}} and are automatically used when the 
\code{\link{plot.tauSurface}} is called.}

\item{title}{Plot title.}

\item{tauNames}{Tau surface names to use for the plot legend in the case of 
comparison of estimates (i.e. when \code{tauSurface2} is provided).}

\item{digits}{Number of digits used in \code{\link[base]{format}} for the 
dose labels.}

\item{facetOpts}{Arguments passed to \code{\link[ggplot2]{facet_wrap}}}
}
\value{
A ggplot2 object.
}
\description{
Plot estimated interaction index surface slice along one of the doses
}
\details{
The function returns a 2d plot for the interaction index (tau) 
estimates as a function of one of the two doses in a checkerboard design, or 
rays in a ray design. Pointwise confidence intervals are displayed as error 
bars. In addition to plotting tau estimates from one \code{tauSurface} object, 
the function can be used to compare two \code{tauSurface} objects. 
This can be used, for example, to see the difference between Wald-type and 
boostrap-based confidence intervals for tau.
Although the function can be used 'manually', typically one calls the 
\code{\link{plot.tauSurface}} method, which then calls this function when
\code{which = "2d"}.
}
\seealso{
\code{\link{plot.tauSurface}}, \code{\link{tauPlot3d}}
}
\author{
Maxim Nazarov
}
