% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_bias_normal.R
\name{EPsProg_bias_normal}
\alias{EPsProg_bias_normal}
\alias{EPsProg_normal_L}
\alias{EPsProg_normal_L2}
\alias{EPsProg_normal_R}
\alias{EPsProg_normal_R2}
\title{Expected probability of a successful program for bias adjustment programs with normally distributed outcomes}
\usage{
EPsProg_normal_L(
  kappa,
  n2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  fixed
)

EPsProg_normal_L2(
  kappa,
  n2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  fixed
)

EPsProg_normal_R(
  kappa,
  n2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  fixed
)

EPsProg_normal_R2(
  kappa,
  n2,
  Adj,
  alpha,
  beta,
  step1,
  step2,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  fixed
)
}
\arguments{
\item{kappa}{threshold value for the go/no-go decision rule}

\item{n2}{total sample size for phase II; must be even number}

\item{Adj}{adjustment parameter}

\item{alpha}{significance level}

\item{beta}{1-beta power for calculation of sample size for phase III}

\item{step1}{lower boundary for effect size}

\item{step2}{upper boundary for effect size}

\item{w}{weight for mixture prior distribution}

\item{Delta1}{assumed true treatment effect for standardized difference in means}

\item{Delta2}{assumed true treatment effect for standardized difference in means}

\item{in1}{amount of information for \code{Delta1} in terms of sample size}

\item{in2}{amount of information for \code{Delta2} in terms of sample size}

\item{a}{lower boundary for the truncation}

\item{b}{upper boundary for the truncation}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{Delta1} is used as fixed effect}
}
\value{
The output of the functions \code{EPsProg_normal_L()}, \code{EPsProg_normal_L2()}, \code{EPsProg_normal_R()} and \code{EPsProg_normal_R2()} is the expected probability of a successful program.
}
\description{
To discount for overoptimistic results in phase II when calculating the optimal sample size in phase III,
it is necessary to use the following functions, which each describe a specific case:
\itemize{
\item \code{EPsProg_normal_L()}: calculates the expected probability of a successful for an additive adjustment factor (i.e. adjust the lower bound of the one-sided confidence interval),
however the go-decision is not affected by the bias adjustment
\item \code{EPsProg_normal_L2()}: calculates the expected probability of a successful for an additive adjustment factor (i.e. adjust the lower bound of the one-sided confidence interval)
when the go-decision is also affected by the bias adjustment
\item \code{EPsProg_normal_R()}: calculates the expected probability of a successful for a multiplicative adjustment factor (i.e. use estimate with a retention factor),
however the go-decision is not affected by the bias adjustment
\item \code{EPsProg_normal_R2()}: calculates the expected probability of a successful for a multiplicative adjustment factor (i.e. use estimate with a retention factor)
when the go-decision is also affected by the bias adjustment
}
}
\examples{
res <- EPsProg_normal_L(kappa = 0.1, n2 = 50, Adj = 0, 
                                 alpha = 0.025, beta = 0.1, w = 0.3,
                                 step1 = 0, step2 = 0.5,
                                 Delta1 = 0.375, Delta2 = 0.625, 
                                 in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, fixed = FALSE)
          res <- EPsProg_normal_L2(kappa = 0.1, n2 = 50, Adj = 0, 
                                 alpha = 0.025, beta = 0.1, w = 0.3,
                                 step1 = 0, step2 = 0.5,
                                 Delta1 = 0.375, Delta2 = 0.625, 
                                 in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, fixed = FALSE)
          res <- EPsProg_normal_R(kappa = 0.1, n2 = 50, Adj = 1, 
                                 alpha = 0.025, beta = 0.1, w = 0.3,
                                 step1 = 0, step2 = 0.5,
                                 Delta1 = 0.375, Delta2 = 0.625, 
                                 in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, fixed = FALSE)
          res <- EPsProg_normal_R2(kappa = 0.1, n2 = 50, Adj = 1, 
                                 alpha = 0.025, beta = 0.1, w = 0.3,
                                 step1 = 0, step2 = 0.5,
                                 Delta1 = 0.375, Delta2 = 0.625, 
                                 in1 = 300, in2 = 600, 
                                 a = 0.25, b = 0.75, fixed = FALSE)
}
\keyword{internal}
