% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_normal_generic.R
\name{optimal_normal_generic}
\alias{optimal_normal_generic}
\title{Generic function for optimizing normally distributed endpoints}
\usage{
optimal_normal_generic(
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  n2min,
  n2max,
  stepn2,
  kappamin,
  kappamax,
  stepkappa,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  steps1 = 0,
  stepm1 = 0.5,
  stepl1 = 0.8,
  b1,
  b2,
  b3,
  gamma = 0,
  fixed = FALSE,
  num_cl = 1
)
}
\arguments{
\item{w}{weight for
\href{https://web.imbi.uni-heidelberg.de/prior/}{mixture prior distribution}}

\item{Delta1}{assumed true prior treatment effect measured as the
standardized difference in means, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here} for details}

\item{Delta2}{assumed true prior treatment effect measured as the
standardized difference in means, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here} for details}

\item{in1}{amount of information for \code{Delta1} in terms of sample size, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{in2}{amount of information for \code{Delta2} in terms of sample size, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{a}{lower boundary for the truncation of the \href{https://web.imbi.uni-heidelberg.de/prior/}{prior distribution}}

\item{b}{upper boundary for the truncation of the \href{https://web.imbi.uni-heidelberg.de/prior/}{prior distribution}}

\item{n2min}{minimal total sample size for phase II; must be an even number}

\item{n2max}{maximal total sample size for phase II, must be an even number}

\item{stepn2}{step size for the optimization over n2; must be an even number}

\item{kappamin}{minimal threshold value kappa for the go/no-go decision rule}

\item{kappamax}{maximal threshold value  kappa for the go/no-go decision rule}

\item{stepkappa}{step size for the optimization over the threshold value kappa}

\item{alpha}{one-sided significance level}

\item{beta}{type II error rate; i.e. \code{1 - beta} is the power for calculation of the sample size for phase III}

\item{c2}{variable per-patient cost for phase II in 10^5 $}

\item{c3}{variable per-patient cost for phase III in 10^5 $}

\item{c02}{fixed cost for phase II in 10^5 $}

\item{c03}{fixed cost for phase III in 10^5 $}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category "small", default: 0}

\item{stepm1}{lower boundary for effect size category "medium" = upper boundary for effect size category "small" default: 0.5}

\item{stepl1}{lower boundary for effect size category "large" = upper boundary for effect size category "medium", default: 0.8}

\item{b1}{expected gain for effect size category "small" in 10^5 $}

\item{b2}{expected gain for effect size category "medium" in 10^5 $}

\item{b3}{expected gain for effect size category "large" in 10^5 $}

\item{gamma}{to model different populations in phase II and III choose \code{gamma != 0}, default: 0, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{fixed}{choose if true treatment effects are fixed or following a prior distribution, if TRUE \code{Delta1} is used as fixed effect}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\description{
Generic function for optimizing normally distributed endpoints
}
\keyword{internal}
