% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_tte_generic.R
\name{optimal_tte_generic}
\alias{optimal_tte_generic}
\title{Generic function for optimal planning of time-to-event endpoints}
\usage{
optimal_tte_generic(
  w,
  hr1,
  hr2,
  id1,
  id2,
  d2min,
  d2max,
  stepd2,
  hrgomin,
  hrgomax,
  stephrgo,
  alpha,
  beta,
  xi2,
  xi3,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  steps1 = 1,
  stepm1 = 0.95,
  stepl1 = 0.85,
  b1,
  b2,
  b3,
  gamma = 0,
  fixed = FALSE,
  num_cl = 1
)
}
\arguments{
\item{w}{weight for mixture prior distribution, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{this Shiny application}
for the choice of weights}

\item{hr1}{first assumed true treatment effect on HR scale for \href{https://web.imbi.uni-heidelberg.de/prior/}{prior distribution}}

\item{hr2}{second assumed true treatment effect on HR scale for \href{https://web.imbi.uni-heidelberg.de/prior/}{prior distribution}}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{d2min}{minimal number of events for phase II}

\item{d2max}{maximal number of events for phase II}

\item{stepd2}{step size for the optimization over d2}

\item{hrgomin}{minimal threshold value for the go/no-go decision rule}

\item{hrgomax}{maximal threshold value for the go/no-go decision rule}

\item{stephrgo}{step size for the optimization over HRgo}

\item{alpha}{one-sided significance level}

\item{beta}{type II error rate; i.e. \code{1 - beta} is the power for calculation of the number of events for phase III by Schoenfeld's formula (Schoenfeld 1981)}

\item{xi2}{assumed event rate for phase II, used for calculating the sample size of phase II via \code{n2 = d2/xi2}}

\item{xi3}{event rate for phase III, used for calculating the sample size of phase III in analogy to \code{xi2}}

\item{c2}{variable per-patient cost for phase II in 10^5 $.}

\item{c3}{variable per-patient cost for phase III in 10^5 $.}

\item{c02}{fixed cost for phase II in 10^5 $.}

\item{c03}{fixed cost for phase III in 10^5 $.}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category "small" in HR scale, default: 1}

\item{stepm1}{lower boundary for effect size category "medium" in HR scale = upper boundary for effect size category "small" in HR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category "large" in HR scale = upper boundary for effect size category "medium" in HR scale, default: 0.85}

\item{b1}{expected gain for effect size category "small"}

\item{b2}{expected gain for effect size category "medium"}

\item{b3}{expected gain for effect size category "large"}

\item{gamma}{to model different populations in phase II and III choose \code{gamma != 0}, default: 0}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE hr1 is used as a fixed effect and hr2 is ignored}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\description{
Generic function for optimal planning of time-to-event endpoints
}
\keyword{internal}
