% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.arrange.R
\name{ds.arrange}
\alias{ds.arrange}
\title{Order the rows of a data frame by the values of selected columns}
\usage{
ds.arrange(
  df.name = NULL,
  tidy_expr = NULL,
  .by_group = NULL,
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{df.name}{Character specifying a serverside data frame or tibble.}

\item{tidy_expr}{A list containing variables, or functions of variables. Use \code{dplyr::desc()} to sort a
variable in descending order.}

\item{.by_group}{If TRUE, will sort first by grouping variable. Applies to grouped data frames
only.}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{DataSHIELD connections object.}
}
\value{
No return value, called for its side effects. An object (typically a data frame or tibble) with the name specified by \code{newobj} is created on the server.
}
\description{
DataSHIELD implentation of \code{dplyr::arrange}.
}
\examples{
\dontrun{
ds.arrange(
  df.name = "mtcars",
  tidy_expr = list(drat),
  newobj = "sorted_df",
  datasources = conns
)
}
}
