% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsem.R
\name{dsem}
\alias{dsem}
\title{Fit dynamic structural equation model}
\usage{
dsem(
  sem,
  tsdata,
  family = rep("fixed", ncol(tsdata)),
  estimate_delta0 = FALSE,
  control = dsem_control()
)
}
\arguments{
\item{sem}{Specification for time-series structural equation model structure
including lagged or simultaneous effects.  See Details section in
\code{\link[dsem]{make_dsem_ram}} for more description}

\item{tsdata}{time-series data, as outputted using \code{\link[stats]{ts}}}

\item{family}{Character-vector listing the distribution used for each column of \code{tsdata}, where
each element must be \code{fixed} or \code{normal}.
\code{family="fixed"} is default behavior and assumes that a given variable is measured exactly.
Other options correspond to different specifications of measurement error.}

\item{estimate_delta0}{Boolean indicating whether to estimate deviations from equilibrium in initial year
as fixed effects, or alternatively to assume that dynamics start at some stochastic draw away from
the stationary distribution}

\item{control}{Output from \code{\link{dsem_control}}, used to define user
settings, and see documentation for that function for details.}
}
\value{
An object (list) of class `dsem`. Elements include:
\describe{
\item{obj}{TMB object from \code{\link[TMB]{MakeADFun}}}
\item{ram}{RAM parsed by \code{make_dsem_ram}}
\item{model}{SEM structure parsed by \code{make_dsem_ram} as intermediate description of model linkages}
\item{tmb_inputs}{The list of inputs passed to \code{\link[TMB]{MakeADFun}}}
\item{opt}{The output from \code{\link[stats]{nlminb}}}
\item{sdrep}{The output from \code{\link[TMB]{sdreport}}}
}
}
\description{
Fits a dynamic structural equation model
}
\details{
A DSEM involves (at a minimum):
\describe{
  \item{Time series}{a matrix \eqn{\mathbf X} where column \eqn{\mathbf x_c} for variable c is
        a time-series;}
  \item{Path diagram}{a user-supplied specification for the path coefficients, which
        define the precision (inverse covariance) \eqn{\mathbf Q} for a matrix of state-variables
        and see \code{\link{make_dsem_ram}} for more details on the math involved.}
}
The model also estimates the time-series mean \eqn{ \mathbf{\mu}_c } for each variable.
The mean and precision matrix therefore define a Gaussian Markov random field for \eqn{\mathbf X}:

\deqn{ \mathrm{vec}(\mathbf X) \sim \mathrm{MVN}( \mathrm{vec}(\mathbf{I_T} \otimes \mathbf{\mu}), \mathbf{Q}^{-1}) }

Users can the specify
a distribution for measurement errors (or assume that variables are measured without error) using
argument \code{family}.  This defines the link-function \eqn{g_c(.)} and distribution \eqn{f_c(.)}
for each time-series \eqn{c}:

\deqn{ y_{t,c} \sim f_c( g_c^{-1}( x_{t,c} ), \theta_c )}

\code{dsem} then estimates all specified coefficients, time-series means \eqn{\mu_c}, and distribution
measurement errors \eqn{\theta_c} via maximizing a log-marginal likelihood, while
also estimating state-variables \eqn{x_{t,c}}.
\code{summary.dsem} then assembles estimates and standard errors in an easy-to-read format.
Standard errors for fixed effects (path coefficients, exogenoux variance parameters, and measurement error parameters)
are estimated from the matrix of second derivatives of the log-marginal likelihod,
and standard errors for random effects (i.e., missing or state-space variables) are estimated
from a generalization of this method (see \code{\link[TMB]{sdreport}} for details).
}
\examples{
# Define model
sem = "
  # Link, lag, param_name
  cprofits -> consumption, 0, a1
  cprofits -> consumption, 1, a2
  pwage -> consumption, 0, a3
  gwage -> consumption, 0, a3
  cprofits -> invest, 0, b1
  cprofits -> invest, 1, b2
  capital -> invest, 0, b3
  gnp -> pwage, 0, c2
  gnp -> pwage, 1, c3
  time -> pwage, 0, c1
"

# Load data
data(KleinI, package="AER")
TS = ts(data.frame(KleinI, "time"=time(KleinI) - 1931))
tsdata = TS[,c("time","gnp","pwage","cprofits",'consumption',
               "gwage","invest","capital")]

# Fit model
fit = dsem( sem=sem,
            tsdata = tsdata,
            estimate_delta0 = TRUE,
            control = dsem_control(quiet=TRUE) )
summary( fit )
plot( fit )
plot( fit, edge_label="value" )

}
\references{
**Introducing the package, its features, and comparison with other software
(to cite when using dsem):**

Thorson, J. T., Andrews, A., Essington, T., Large, S. (In review).
Dynamic structural equation models synthesize
ecosystem dynamics constrained by ecological mechanisms.
}
