# Tests of DSE curvature functions from dsecurvature.function.testsA
 require("dse2"); require("curve") #,  warn.conflicts=F)
 Sys.info()
 version.dse()
 
fuzz.small <- 1e-12
fuzz.large <- 1e-6
fuzz.very.large <- 1e-2
digits <- 18
all.ok <- T
test.rng <- list(kind="Wichmann-Hill",seed=c(979,1479,1542),normal.kind="Box-Muller")


# comparison values come only from a previous run of the 
#  code (theoretical values would be nice)...
# Test values have been changed with change to RNG when R 1.0.0 was released
#   (Feb. 29, 2000) and also previously.
  

# from user guide

  VARmodel<-ARMA(A=array(c(1,.5,.3,0,.2,.1,0,.2,.05,1,.5,.3),c(3,2,2)),
             B=array(c(1,.2,0,.1,0,0,1,.3),c(2,2,2)), C=NULL) 

# Note this gives a terrible fit.
  VARmodel<-l(VARmodel,simulate(VARmodel, rng=test.rng))
  SSmodel  <- l(to.SS(VARmodel),  VARmodel$data)
  ARMAmodel<- l(to.ARMA(SSmodel), VARmodel$data)

cat("DSE curvature test A 10a..")
  spanARMA.f <- span(ARMAmodel, compiled=.DSECOMPILED)

# if(is.Splus()) good <-  c(
#     2.77119952678264987e+01, 2.53919116411379555e+01, 2.32812418066877100e+01,
#     1.90837600070161528e+01, 1.73322831223985432e+01, 1.48319783197278330e+01,
#     1.41417499505086042e+01, 1.19871189922967893e+01, 1.16051570137965676e+01,
#     1.08623372662499182e+01, 7.21807567275184692e+00, 6.80015402524795309e+00,
#     5.99427285923686615e+00, 5.84925830647237177e+00, 3.02327766004096032e+00,
#     2.67973563219726740e+00, 7.50824755195420801e-01, 4.76770151276800724e-01,
#     6.30824258854855713e-15, 1.22839566408688817e-15, 6.66516531623418467e-17,
#      0.00000000000000000e+00 )
#  if(is.R())     good <-  c(
#       3.0111693007925084e+01, 2.6903738538557757e+01, 2.1949166927772083e+01,
#       1.9412118834825545e+01, 1.7023849849248617e+01, 1.5059167312762057e+01,
#       1.2198080331280515e+01, 1.1203212614180140e+01, 1.0534424040150872e+01,
#       9.7611634784175791e+00, 6.7724158272123773e+00, 6.0772753814400602e+00,
#       5.5378918184900012e+00, 5.2255556591227439e+00, 2.7020830182124316e+00,
#       2.5433734102944965e+00, 7.4778345526592260e-01, 4.6199586045921071e-01,
#       5.5366294436852289e-07, 2.5570412409273409e-07, 7.3166444674331792e-17,
#       0.0000000000000000e+00)         #f77 on Sun5 R0.61.1

#   c( 3.011169300794247e+01, 2.690373853859740e+01, 2.194916692782002e+01,
#      1.941211883487011e+01, 1.702384984930141e+01, 1.505916731276925e+01,
#      1.219808033127580e+01, 1.120321261421515e+01, 1.053442404016652e+01,
#      9.761163478425873e+00, 6.772415827211282e+00, 6.077275381439208e+00,
#      5.537891818483530e+00, 5.225555659106909e+00, 2.702083018243574e+00,
#      2.543373410280471e+00, 7.477834552669831e-01, 4.619958604596496e-01,
#      2.038270252146126e-06, 2.556984253017427e-07, 1.795257106881694e-15,
#      7.973651962079763e-17))) #R0.49
#      c( 2.768304162846298e+01, 2.393941491091734e+01, 1.988022205000436e+01, 
#         1.822550017859639e+01, 1.630502757392022e+01, 1.461512246650834e+01, 
#         1.275451631155268e+01, 1.221047501548486e+01, 1.073726354564602e+01, 
#         1.026204415323931e+01, 7.265742818227836e+00, 6.282013694588179e+00, 
#         5.974725282653903e+00, 5.251293695221127e+00, 2.860581954100438e+00, 
#         2.471994703685991e+00, 7.121798982572878e-01, 4.406741938800671e-01, 
#         1.433057563479431e-15, 9.026520997009618e-16, 4.800022955996391e-17, 
#         0.000000000000000e+00 )))

# R Solaris
  good <-  c(3011.318489057963,  19.37947620116293,  17.47202335066703,
            15.20951506186483,  13.78393160485094,  12.03840540489752, 
             9.92428984973578,   9.697246859100282,  9.244229358342194,
             7.152271025275832,  7.092732858677983,  5.69297886809311,  
             4.736206089454028,  4.304104324296326,  3.708282982105869, 
             2.11735492156378,   1.95253799784708,   0.5057146032686363, 
             0.3160112544521056, 2.867793448120931e-15, 8.538596555411535e-16,
                  0)

# R Linux
  good <- c( 19.5069136184747691,   17.473349776355132,  15.3942712009364495,
            13.7862136356176972,  12.0470502264922672,  9.93058117606233282,
            9.70738285213095686,  9.39682286923732946,  7.15244420534333436,
            7.14045582919181054,  5.72442802958446784,  4.74384059078413145,
            4.3178723214231276,   3.7093267481375447,  2.13283668011786354,
            1.95407955864386418,  0.506460713920498851,  0.316713386010944509,
            8.73275433068441726e-16,  2.91045244991302892e-16)

# Splus Solaris values:
#c(  [1]  2.854799065168644e+03  1.927325423818564e+01  1.745392647304185e+01
# [4]  1.508940688448259e+01  1.377654544670931e+01  1.203796836342551e+01
# [7]  9.926711794026920e+00  9.705558069753085e+00  9.214674640019336e+00
#[10]  7.151912789329529e+00  7.110891344071947e+00  5.676460671597718e+00
#[13]  4.724769204414272e+00  4.311928305576296e+00  3.708361783746251e+00
#[16]  2.130165310609959e+00  1.953704281613287e+00  5.057391241655013e-01
#[19]  3.137209572167103e-01  1.310169543169194e-15  5.690213922485003e-16
#[22]  0.000000000000000e+00 )
warning("Skipping 10a comparison. Problem is too ill-conditioned.")

#  tst <- spanARMA.f
 
 cat("DSE curvature test A 10b..")

  spanARMA <- span(ARMAmodel, compiled=F) 


   tst  <-  spanARMA
   good <-  spanARMA.f
   error <- max(abs(good-tst))
   cat("max. error ", max(error))
   
   if (any(is.na(error)) || any(is.nan(error)) || fuzz.small < error) 
     {print.test.value(c(tst), digits=18); all.ok <- F }

 cat("DSE curvature test A 10c..")

  ARMAmodel.fixed <- l(fix.constants(ARMAmodel), VARmodel$data)
  spanARMA.fix <- span(ARMAmodel.fixed)

#  if(is.Splus()) good <-  c(
#     27.711995267845011881, 25.391911641137962619, 23.281241806692566598,
#     19.083760007020678984, 17.332283122405144127, 14.831978319714982817,
#     14.141749950539304947, 11.987118992298254838, 11.605157013791078668,
#     10.862337266239681099,  7.218075672755373873,  6.800154025249395495,
#      5.994272859236035700,  5.849258306460957790,  3.023277660033443670,
#      2.679735632202348672,  0.750824755198911564,  0.476770151275852538 )
#  if(is.R())     good <-  c(
#     30.11169300792521142, 26.90373853855186326, 21.94916692777263734,
#     19.41211883482275269, 17.02384984926177935, 15.05916731276262510,
#     12.19808033128727054, 11.20321261418225234, 10.53442404015623701,
#      9.76116347841036180,  6.77241582721368829,  6.07727538144364043,
#      5.53789181847943901,  5.22555565912482223,  2.70208301821842412,
#      2.54337341031345465,  0.74778345526932322,  0.46199586045587798 ) 

#  good <- c(19.50691361845315,  17.47334977636005,  15.39427120095003,
#          13.78621363562109,  12.04705022651371,  9.930581176044308,  
#          9.707382852080064,  9.396822869247679,  7.152444205356154,  
#          7.140455829182858,  5.724428029579137,  4.743840590786617,  
#          4.317872321424001,  3.709326748136878,  2.132836680138603,  
#          1.954079558657604,  0.5064607139184161,  0.3167133860055982)

  good <- c(26.3659986552698982,  23.8359546246227616,  19.5634874084708699,
           17.2143457352275391,  15.1394364958679244,  14.7208570925179494,  
	   12.4221689849793311,  11.2407321096646733,  10.7899650394872069,  
	   10.1698037554743284,  7.99664809385088837,  6.32142067466109392,  
	    6.29099304634241019,  5.47437857637598668,  2.66712150086359934,  
	    2.51249349659001497,  0.683166443549642177,  0.459517858793767109)

   tst  <-  spanARMA.fix
   error <- max(abs(good-tst))
   cat("max. error ", max(error))
     
   if (any(is.na(error)) || any(is.nan(error)) || fuzz.large < error) 
     {print.test.value(c(tst), digits=18); all.ok <- F }

  if (! all.ok) stop("some tests FAILED")
