% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cop.R
\name{dcop}
\alias{dcop}
\alias{pcop}
\alias{rcop}
\title{Copula function}
\usage{
dcop(W, delta, family_cop = "normal", log.p = FALSE, deriv = 0)

pcop(W, delta = 0, family_cop = "normal", log.p = FALSE)

rcop(n, delta = 0, family_cop = "normal")
}
\arguments{
\item{W}{matrix of pseudo observations. Must have at least two columns.}

\item{delta}{matrix of copula parameter. Must have at least one column.}

\item{family_cop}{string, defines the copula family:\cr
\code{independent} = Independence copula \cr
\code{normal} = Gaussian copula \cr
\code{clayton} = Clayton copula \cr
\code{gumbel} = Gumbel copula \cr
\code{frank} = Frank copula \cr
\code{joe} = Joe copula \cr}

\item{log.p}{logical; if \code{TRUE}, probabilities p are given as \code{log(p)}.}

\item{deriv}{derivative of order \code{deriv} of the log density. Available are \code{0},\code{2}.}

\item{n}{number of observations.}
}
\value{
\code{dcop} gives the density, \code{pcop} gives the distribution function for a specified copula and \code{rcop} generates random numbers, with given delta.
If the derivatives are calculated these are provided as the attributes \code{gradient}, \code{hessian} of the output of the density.
}
\description{
Probablitiy density function, distribution and random number generation for copulas.
}
\details{
For more than 2 dimensions only the gaussian copula is implemented. The functions \code{pcop} and \code{rcop} are wrapper functions for 'copula' package.
The functions \code{pcop} and \code{rcop} are wrapper functions for the \code{\link[copula:pCopula]{pCopula()}} and \code{\link[copula:rCopula]{rCopula()}}.
Although the parameter space is larger in theory for some copulas, numeric under- and overflow limit the parameter space. The intervalls for the parameter \code{delta} are given as follows:
\enumerate{
\item  \code{independent}, min=0 and max=1
\item  \code{normal}, min=-1 and max=1
\item  \code{clayton}, min=1e-16 and max=28
\item  \code{gumbel}, min=1 and max=17
\item  \code{frank}, min=-35 and max=35
\item  \code{joe}, min=1e-16 and max=30
}
}
\section{Functions}{
\itemize{
\item \code{pcop()}: distribution function for copula.

\item \code{rcop()}: random number generation for copula.

}}
\examples{
u=0.3; v=0.7; p=0.5
pdf <- dcop(W=matrix(c(u,v), ncol=2), delta=matrix(p,ncol=1), family_cop="normal")
cdf <- pcop(W=matrix(c(u,v), ncol=2), delta=matrix(p,ncol=1), family_cop="normal")
r <- rcop(n=100, delta=matrix(p,nrow=100), family_cop="normal")

}
\references{
\itemize{
\item \insertRef{schepsmeier2014derivatives}{dsfa}
\item \insertRef{hofert2018elements}{dsfa}
}
}
