% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfactor.R
\name{dfactor}
\alias{dfactor}
\title{Demographic Factor Frequencies Tables}
\usage{
dfactor(data1, vars, neat = TRUE, sizesort = TRUE)
}
\arguments{
\item{data1}{a \code{data.frame}}

\item{vars}{a vector of one or more variable names in \code{data1}}

\item{neat}{logical, \code{TRUE} returns a rounded table with percent symbols}

\item{sizesort}{logical, \code{TRUE} returns table sorted by size}
}
\value{
Returns a demographic frequencies table in \code{data.frame} format.
}
\description{
This function converts columns from a \code{data.frame} into a
frequencies table formatted in standard presentation structure with percent
symbols.
}
\examples{
# Single frequency table
dfactor(iris2, "Species")

# Multiple frequency tables
dfactor(iris2, c("Color", "Species"))
}

