% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relational.R
\name{rel_inner_join}
\alias{rel_inner_join}
\title{Lazily INNER join two DuckDB relation objects}
\usage{
rel_inner_join(left, right, conds)
}
\arguments{
\item{left}{the left-hand-side DuckDB relation object}

\item{right}{the right-hand-side DuckDB relation object}

\item{conds}{a list of DuckDB expressions to use for the join}
}
\value{
a new \code{duckdb_relation} object resulting from the join
}
\description{
Lazily INNER join two DuckDB relation objects
}
\examples{
con <- DBI::dbConnect(duckdb())
DBI::dbExecute(con, 'CREATE MACRO eq(a, b) AS a = b')
left <- rel_from_df(con, mtcars)
right <- rel_from_df(con, mtcars)
cond <- list(expr_function("eq", list(expr_reference("cyl", left), expr_reference("cyl", right))))
rel2 <- rel_inner_join(left, right, cond)
}
