# Generated by 02-duckplyr_df-methods.R
#' @export
setequal.duckplyr_df <- function(x, y, ...) {
  # Our implementation
  rel_try(
    "No relational implementation for setequal()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  setequal <- dplyr$setequal.data.frame
  out <- setequal(x, y, ...)
  return(out)

  # dplyr implementation
  check_dots_empty()
  check_compatible(x, y)

  cast <- vec_cast_common(x = x, y = y)
  all(vec_in(cast$x, cast$y)) && all(vec_in(cast$y, cast$x))
}

duckplyr_setequal <- function(x, y, ...) {
  try_fetch(
    {
      x <- as_duckplyr_df(x)
      y <- as_duckplyr_df(y)
    },
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- setequal(x, y, ...)
  out
}
